/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Injector;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;

public abstract class FactoryInjector<T>
implements Injector<T> {
    private Class key;

    public FactoryInjector() throws PicoCompositionException {
        this.key = FactoryInjector.getTypeArguments(FactoryInjector.class, this.getClass()).get(0);
        if (this.key == null) {
            this.key = CantWorkItOut.class;
        }
    }

    public FactoryInjector(Class<T> key) {
        this.key = key;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return FactoryInjector.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = FactoryInjector.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<FactoryInjector> class1, Class<? extends Object> class2) {
        HashMap resolvedTypes = new HashMap();
        Type type = class2;
        while (!FactoryInjector.getClass(type).equals(class1)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(class1)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(FactoryInjector.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    @Override
    public Object getComponentKey() {
        return this.key;
    }

    @Override
    public Class<? extends T> getComponentImplementation() {
        return this.key;
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
    }

    @Override
    public ComponentAdapter<T> getDelegate() {
        return null;
    }

    @Override
    public <U extends ComponentAdapter> U findAdapterOfType(Class<U> adapterType) {
        return null;
    }

    @Override
    public T getComponentInstance(PicoContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract T getComponentInstance(PicoContainer var1, Type var2);

    @Override
    public Object decorateComponentInstance(PicoContainer container, Type into, T instance) {
        return null;
    }

    @Override
    public void verify(PicoContainer container) {
    }

    @Override
    public String getDescriptor() {
        return "FactoryInjector-";
    }

    public void start(PicoContainer container) {
    }

    public void stop(PicoContainer container) {
    }

    public void dispose(PicoContainer container) {
    }

    public boolean componentHasLifecycle() {
        return false;
    }

    public static class CantWorkItOut {
        private CantWorkItOut() {
        }
    }
}

