/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Profile;
import com.izforge.izpack.api.config.Reg;
import com.izforge.izpack.api.config.Registry;
import com.izforge.izpack.api.config.spi.AbstractProfileBuilder;
import com.izforge.izpack.api.config.spi.RegEscapeTool;
import com.izforge.izpack.api.config.spi.ServiceFinder;
import com.izforge.izpack.api.config.spi.TypeValuesPair;

public class RegBuilder
extends AbstractProfileBuilder {
    private Reg _reg;

    public static RegBuilder newInstance(Reg reg) {
        RegBuilder instance = RegBuilder.newInstance();
        instance.setReg(reg);
        return instance;
    }

    public void setReg(Reg value) {
        this._reg = value;
    }

    @Override
    public void handleOption(String rawName, String rawValue) {
        String name = rawName.charAt(0) == '\"' ? RegEscapeTool.getInstance().unquote(rawName) : rawName;
        TypeValuesPair tv = RegEscapeTool.getInstance().decode(rawValue);
        if (tv == null) {
            return;
        }
        if (tv.getType() != Registry.Type.REG_SZ) {
            ((Registry.Key)this.getCurrentSection()).putType(name, tv.getType());
        }
        for (String value : tv.getValues()) {
            super.handleOption(name, value);
        }
    }

    @Override
    Config getConfig() {
        return this._reg.getConfig();
    }

    @Override
    Profile getProfile() {
        return this._reg;
    }

    private static RegBuilder newInstance() {
        return ServiceFinder.findService(RegBuilder.class);
    }
}

