/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.PackCompression;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;

public final class StreamSupport {
    public static OutputStream compressedOutput(PackCompression comprFormat, OutputStream outputStream) throws IOException {
        switch (comprFormat) {
            case DEFAULT: {
                return outputStream;
            }
            case DEFLATE: {
                DeflateParameters deflateParameters = new DeflateParameters();
                deflateParameters.setCompressionLevel(9);
                return new DeflateCompressorOutputStream(outputStream, deflateParameters);
            }
        }
        try {
            return new CompressorStreamFactory().createCompressorOutputStream(comprFormat.toName(), outputStream);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }

    public static InputStream compressedInput(PackCompression comprFormat, InputStream inputStream) throws IOException {
        switch (comprFormat) {
            case DEFAULT: {
                return inputStream;
            }
            case DEFLATE: {
                DeflateParameters deflateParameters = new DeflateParameters();
                deflateParameters.setCompressionLevel(9);
                return new DeflateCompressorInputStream(inputStream, deflateParameters);
            }
        }
        try {
            return new CompressorStreamFactory().createCompressorInputStream(comprFormat.toName(), inputStream);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }
}

