/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.io.PrintWriter;

public abstract class AbstractConsolePanel
implements ConsolePanel {
    private final PanelView<ConsolePanel> panel;

    public AbstractConsolePanel(PanelView<ConsolePanel> panel) {
        this.panel = panel;
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        return true;
    }

    protected boolean promptEndPanel(InstallData installData, Console console) {
        String prompt = installData.getMessages().get("ConsoleInstaller.continueQuitRedisplay", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 3, 2);
        boolean result = value == 1 || value != 2 && this.run(installData, console);
        return result;
    }

    protected boolean promptRerunPanel(InstallData installData, Console console) {
        String prompt = installData.getMessages().get("ConsoleInstaller.redisplayQuit", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 2, 2);
        boolean result = value != 2 && this.run(installData, console);
        return result;
    }

    protected Panel getPanel() {
        return this.panel != null ? this.panel.getPanel() : null;
    }

    @Override
    public void createInstallationRecord(IXMLElement rootElement) {
    }
}

