/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.io;

import com.izforge.izpack.core.io.CorruptVolumeException;
import com.izforge.izpack.core.io.FileSpanningOutputStream;
import com.izforge.izpack.core.io.VolumeLocator;
import com.izforge.izpack.core.io.VolumeNotFoundException;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class FileSpanningInputStream
extends InputStream {
    private final SpanningInputStream spanningInputStream;
    private GZIPInputStream zippedInputStream;
    private long filePointer;
    private static final Logger logger = Logger.getLogger(FileSpanningInputStream.class.getName());

    public FileSpanningInputStream(File volume, int volumes) throws IOException {
        this.spanningInputStream = new SpanningInputStream(volume, volumes);
        this.zippedInputStream = new GZIPInputStream(this.spanningInputStream);
    }

    public void setLocator(VolumeLocator locator) {
        this.spanningInputStream.setLocator(locator);
    }

    @Override
    public int available() throws IOException {
        return this.zippedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.zippedInputStream.close();
        this.spanningInputStream.close();
    }

    @Override
    public int read() throws IOException {
        int read = this.zippedInputStream.read();
        if (read != -1) {
            ++this.filePointer;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        int count = -1;
        while (len != 0 && (read = this.zippedInputStream.read(b, off, len)) != -1) {
            off += read;
            len -= read;
            count = count == -1 ? read : count + read;
        }
        if (count != -1) {
            this.filePointer += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        long count = skipped = this.zippedInputStream.skip(n);
        while (skipped != -1L && skipped < n) {
            if ((skipped = this.zippedInputStream.skip(n -= skipped)) == -1L) continue;
            count += skipped;
        }
        if (count != -1L) {
            this.filePointer += count;
        }
        return count;
    }

    public File getVolume() {
        return this.spanningInputStream.getVolume();
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    private static final class SpanningInputStream
    extends InputStream {
        private InputStream stream;
        private String basePath;
        private int index = 0;
        private final int volumes;
        private final byte[] magicNumber;
        private VolumeLocator locator;
        private File current;

        public SpanningInputStream(File volume, int volumes) throws IOException {
            this.basePath = volume.getAbsolutePath();
            this.stream = new FileInputStream(volume);
            this.current = volume;
            this.volumes = volumes;
            this.magicNumber = new byte[10];
            if (this.stream.read(this.magicNumber) != 10) {
                FileUtils.close(this.stream);
                throw new CorruptVolumeException();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Opened volume=" + volume + ", magic=" + FileSpanningOutputStream.formatMagic(this.magicNumber));
            }
        }

        public void setLocator(VolumeLocator locator) {
            this.locator = locator;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count = -1;
            while (len != 0) {
                int read = this.stream.read(b, off, len);
                if (read == -1) {
                    if (this.openNextVolume()) continue;
                    break;
                }
                off += read;
                len -= read;
                count = count == -1 ? read : count + read;
            }
            return count;
        }

        @Override
        public int read() throws IOException {
            int read = this.stream.read();
            if (read == -1 && this.openNextVolume()) {
                read = this.stream.read();
            }
            return read;
        }

        public File getVolume() {
            return this.current;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        private boolean openNextVolume() throws IOException {
            boolean result;
            if (this.index + 1 >= this.volumes) {
                logger.fine("Last volume reached");
                result = false;
            } else {
                String volumePath = this.basePath + "." + (this.index + 1);
                File volume = new File(volumePath);
                boolean found = false;
                while (!found) {
                    if (volume.exists()) {
                        try {
                            FileUtils.close(this.stream);
                            this.stream = new FileInputStream(volume);
                            this.current = volume;
                            this.checkMagicNumber();
                            found = true;
                        }
                        catch (CorruptVolumeException exception) {
                            if (this.locator == null) {
                                throw exception;
                            }
                            volume = this.locator.getVolume(volume.getAbsolutePath(), true);
                        }
                        continue;
                    }
                    if (this.locator != null) {
                        volume = this.locator.getVolume(volume.getAbsolutePath(), false);
                        continue;
                    }
                    throw new VolumeNotFoundException("Volume not found: " + volume.getAbsolutePath(), volume.getAbsolutePath());
                }
                ++this.index;
                result = true;
            }
            return result;
        }

        private void checkMagicNumber() throws IOException {
            logger.fine("Trying to read magic number");
            byte[] volumeMagicNo = new byte[10];
            try {
                if (this.stream.read(volumeMagicNo) != volumeMagicNo.length) {
                    logger.fine("Failed to read magic number");
                    throw new CorruptVolumeException();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Magic number is " + FileSpanningOutputStream.formatMagic(volumeMagicNo));
                    if (!Arrays.equals(this.magicNumber, volumeMagicNo)) {
                        throw new CorruptVolumeException();
                    }
                }
            }
            catch (IOException exception) {
                FileUtils.close(this.stream);
                throw exception;
            }
        }
    }
}

