/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.JavaRegexpMatcher;
import com.izforge.izpack.util.regex.RegexUtil;
import com.izforge.izpack.util.regex.Regexp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRegexp
extends JavaRegexpMatcher
implements Regexp {
    protected int getSubsOptions(int options) {
        int subsOptions = 1;
        if (RegexUtil.hasFlag(options, 16)) {
            subsOptions = 16;
        }
        return subsOptions;
    }

    @Override
    public String substitute(String input, String argument, int options) throws RuntimeException {
        StringBuffer subst = new StringBuffer();
        for (int i = 0; i < argument.length(); ++i) {
            char c = argument.charAt(i);
            if (c == '$') {
                subst.append('\\');
                subst.append('$');
                continue;
            }
            if (c == '\\') {
                if (++i < argument.length()) {
                    c = argument.charAt(i);
                    int value = Character.digit(c, 10);
                    if (value > -1) {
                        subst.append("$").append(value);
                        continue;
                    }
                    subst.append(c);
                    continue;
                }
                subst.append('\\');
                continue;
            }
            subst.append(c);
        }
        argument = subst.toString();
        int sOptions = this.getSubsOptions(options);
        Pattern p = this.getCompiledPattern(options);
        StringBuffer sb = new StringBuffer();
        Matcher m = p.matcher(input);
        if (RegexUtil.hasFlag(sOptions, 16)) {
            sb.append(m.replaceAll(argument));
        } else {
            boolean res = m.find();
            if (res) {
                m.appendReplacement(sb, argument);
                m.appendTail(sb);
            } else {
                sb.append(input);
            }
        }
        return sb.toString();
    }
}

