/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import java.io.Serializable;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.lifecycle.LifecycleState;

public class DefaultLifecycleState
implements LifecycleState,
Serializable {
    private static final String CONSTRUCTED = "CONSTRUCTED";
    private static final String STARTED = "STARTED";
    private static final String STOPPED = "STOPPED";
    private static final String DISPOSED = "DISPOSED";
    private String state = "CONSTRUCTED";

    @Override
    public void removingComponent() {
        if (this.isStarted()) {
            throw new PicoCompositionException("Cannot remove components after the container has started");
        }
        if (this.isDisposed()) {
            throw new PicoCompositionException("Cannot remove components after the container has been disposed");
        }
    }

    @Override
    public void starting() {
        if (this.isConstructed() || this.isStopped()) {
            this.state = STARTED;
            return;
        }
        throw new IllegalStateException("Cannot start.  Current container state was: " + this.state);
    }

    @Override
    public void stopping() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot stop.  Current container state was: " + this.state);
        }
    }

    @Override
    public void stopped() {
        this.state = STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.state == STARTED;
    }

    @Override
    public void disposing() {
        if (!this.isStopped() && !this.isConstructed()) {
            throw new IllegalStateException("Cannot dispose.  Current lifecycle state is: " + this.state);
        }
    }

    @Override
    public void disposed() {
        this.state = DISPOSED;
    }

    @Override
    public boolean isDisposed() {
        return this.state == DISPOSED;
    }

    @Override
    public boolean isStopped() {
        return this.state == STOPPED;
    }

    public boolean isConstructed() {
        return this.state == CONSTRUCTED;
    }
}

