/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

public class FieldDecorated
extends AbstractBehavior {
    private final Class<?> fieldClass;
    private final Decorator decorator;

    public FieldDecorated(ComponentAdapter delegate, Class<?> fieldClass, Decorator decorator) {
        super(delegate);
        this.fieldClass = fieldClass;
        this.decorator = decorator;
    }

    @Override
    public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Field[] fields;
        Object instance = super.getComponentInstance(container, into);
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            if (field.getType() != this.fieldClass) continue;
            Object value = this.decorator.decorate(instance);
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new PicoCompositionException(e);
            }
        }
        return instance;
    }

    @Override
    public String getDescriptor() {
        return "FieldDecorated";
    }

    public static interface Decorator {
        public Object decorate(Object var1);
    }
}

