/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.os.FileQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CompressedFileUnpacker
extends FileUnpacker {
    private final PackCompression compressionFormat;

    public CompressedFileUnpacker(Cancellable cancellable, FileQueue queue, PackCompression compressionFormat) {
        super(cancellable, queue);
        this.compressionFormat = compressionFormat;
    }

    @Override
    public void unpack(PackFile file, InputStream packInputStream, File target) throws IOException, InstallerException {
        File tmpfile = File.createTempFile("izpack-uncompress", null, FileUtils.getTempDirectory());
        BufferedOutputStream fo = null;
        CompressorInputStream finalStream = null;
        try {
            fo = IOUtils.buffer(FileUtils.openOutputStream(tmpfile));
            long bytesUnpacked = IOUtils.copyLarge(packInputStream, fo, 0L, file.size());
            ((OutputStream)fo).flush();
            ((OutputStream)fo).close();
            if (bytesUnpacked != file.size()) {
                throw new IOException("File size mismatch when reading from pack: " + file.getRelativeSourcePath());
            }
            BufferedInputStream in = IOUtils.buffer(FileUtils.openInputStream(tmpfile));
            if (this.compressionFormat == PackCompression.DEFLATE) {
                DeflateParameters deflateParameters = new DeflateParameters();
                deflateParameters.setCompressionLevel(9);
                finalStream = new DeflateCompressorInputStream((InputStream)in, deflateParameters);
            } else {
                finalStream = new CompressorStreamFactory().createCompressorInputStream(this.compressionFormat.toName(), (InputStream)in);
            }
            long bytesUncompressed = this.copy(file, (InputStream)finalStream, target);
            if (bytesUncompressed != file.length()) {
                throw new IOException("File size mismatch when uncompressing from pack: " + file.getRelativeSourcePath());
            }
        }
        catch (CompressorException e) {
            try {
                throw new IOException("An exception occurred whilst unpacking: " + file.getRelativeSourcePath() + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fo);
                IOUtils.closeQuietly(finalStream);
                FileUtils.deleteQuietly(tmpfile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fo);
        IOUtils.closeQuietly((InputStream)finalStream);
        FileUtils.deleteQuietly(tmpfile);
    }
}

