/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.logging;

import com.izforge.izpack.util.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractFormatter
extends Formatter {
    private final String lineSeparator = System.getProperty("line.separator");
    private final Date dat = new Date();
    private static final String format = "{0,date,yyyy.MM.dd} {0,time,HH:mm:ss}";
    private MessageFormat formatter;
    private final Object[] args = new Object[1];

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (this.isAddTimeStamp()) {
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" ");
        }
        Level level = record.getLevel();
        if (this.isAddMessageLevel() || level.intValue() > Level.INFO.intValue()) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
        }
        String message = this.formatMessage(record);
        sb.append(message);
        Throwable throwable = record.getThrown();
        if (Debug.isSTACKTRACE() && throwable != null) {
            sb.append(this.lineSeparator);
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }

    abstract boolean isAddTimeStamp();

    abstract boolean isAddMessageLevel();
}

