/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.substitutor;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorInputStream;
import com.izforge.izpack.core.substitutor.VariableSubstitutorReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class VariableSubstitutorImpl
implements VariableSubstitutor,
Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    private static final Logger logger = Logger.getLogger(VariableSubstitutorImpl.class.getName());
    private transient Variables variables;
    private boolean bracesRequired = false;

    public VariableSubstitutorImpl(Variables variables) {
        this.variables = variables;
    }

    public boolean isBracesRequired() {
        return this.bracesRequired;
    }

    @Override
    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    @Override
    public String substitute(String str) {
        return this.substitute(str, SubstitutionType.TYPE_PLAIN);
    }

    @Override
    public String substitute(String str, SubstitutionType type) {
        if (str == null) {
            return null;
        }
        try {
            return IOUtils.toString(new VariableSubstitutorReader(new StringReader(str), this.variables, type, this.bracesRequired));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error when substituting variables", e);
            throw new IzPackException(e);
        }
    }

    @Override
    public int substitute(InputStream in, OutputStream out, SubstitutionType type, String encoding) throws Exception {
        return IOUtils.copy((InputStream)new VariableSubstitutorInputStream(in, encoding, this.variables, type, this.bracesRequired), out);
    }

    @Override
    public String substitute(InputStream in, SubstitutionType type) throws Exception {
        VariableSubstitutorInputStream inputStream = new VariableSubstitutorInputStream(in, this.variables, type, this.bracesRequired);
        return IOUtils.toString((InputStream)inputStream, inputStream.getEncoding());
    }

    @Override
    public int substitute(Reader reader, Writer writer, SubstitutionType type) throws Exception {
        return IOUtils.copy((Reader)new VariableSubstitutorReader(reader, this.variables, type, this.bracesRequired), writer);
    }
}

