/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.resource;

import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public abstract class AbstractResources
implements Resources {
    private final ClassLoader loader;

    public AbstractResources() {
        this(AbstractResources.class.getClassLoader());
    }

    public AbstractResources(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public InputStream getInputStream(String name) {
        InputStream result = this.loader.getResourceAsStream(name = this.resolveName(name));
        if (result == null) {
            throw new ResourceNotFoundException("Failed to locate resource: " + name);
        }
        return result;
    }

    @Override
    public URL getURL(String name) {
        URL result = this.getResource(name);
        if (result == null) {
            throw new ResourceNotFoundException("Failed to locate resource: " + name);
        }
        return result;
    }

    @Override
    public String getString(String name) {
        try {
            return this.readString(name, "UTF-8");
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read string resource: " + name, exception);
        }
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getString(name, "UTF-8", defaultValue);
    }

    @Override
    public String getString(String name, String encoding, String defaultValue) {
        String result;
        try {
            result = this.readString(name, encoding);
        }
        catch (Exception exception) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Object getObject(String name) throws ResourceException, ResourceNotFoundException {
        Object result;
        InputStream in = this.getInputStream(name);
        ObjectInputStream objectIn = null;
        try {
            objectIn = new ObjectInputStream(in);
            result = objectIn.readObject();
        }
        catch (Exception exception) {
            try {
                throw new ResourceException("Failed to read resource: " + name, exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectIn);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(objectIn);
        IOUtils.closeQuietly(in);
        return result;
    }

    @Override
    public ImageIcon getImageIcon(String name, String ... alternatives) {
        URL result = this.getResource(name);
        if (result == null) {
            String fallback;
            String[] arr$ = alternatives;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = this.getResource(fallback = arr$[i$])) == null; ++i$) {
            }
        }
        if (result == null) {
            StringBuilder message = new StringBuilder("Image icon resource not found in ");
            message.append(name);
            if (alternatives.length != 0) {
                message.append(" or ");
                message.append(Arrays.toString(alternatives));
            }
            throw new ResourceNotFoundException(message.toString());
        }
        try {
            BufferedImage image = ImageIO.read(result);
            return new ImageIcon(image);
        }
        catch (IOException ex) {
            StringBuilder message = new StringBuilder("Image icon resource not available from url: ");
            message.append(result);
            throw new ResourceNotFoundException(message.toString());
        }
    }

    protected URL getResource(String name) {
        name = this.resolveName(name);
        return this.loader.getResource(name);
    }

    protected String resolveName(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    protected ClassLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readString(String name, String encoding) throws IOException {
        String result;
        InputStream in = this.getInputStream(name);
        try {
            result = IOUtils.toString(in, Charsets.toCharset(encoding));
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return result;
    }
}

