/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.config.spi.OptionsHandler;
import com.izforge.izpack.api.config.spi.ServiceFinder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OptionsBuilder
implements OptionsHandler {
    private List<String> lastComments = new ArrayList<String>();
    private Options _options;

    public static OptionsBuilder newInstance(Options opts) {
        OptionsBuilder instance = OptionsBuilder.newInstance();
        instance.setOptions(opts);
        return instance;
    }

    public void setOptions(Options value) {
        this._options = value;
    }

    @Override
    public void endOptions() {
        this.setFooterComment();
    }

    @Override
    public void handleComment(List<String> comment) {
        this.lastComments.addAll(comment);
    }

    @Override
    public void handleEmptyLine() {
    }

    @Override
    public void handleOption(String name, String value) {
        String newName = name;
        if (this.getConfig().isAutoNumbering() && name.matches("(.+\\.)+[\\d]+")) {
            String[] parts = name.split("\\.");
            newName = name.substring(0, name.length() - parts[parts.length - 1].length() - 1) + ".";
            int pos = Integer.parseInt(parts[parts.length - 1]);
            if (!this._options.containsKey(newName)) {
                this._options.add(newName, null);
            }
            for (int i = this._options.getAll(newName).size(); i <= pos; ++i) {
                this._options.add(newName, null);
            }
            this._options.put(newName, value, pos);
        } else if (this.getConfig().isMultiOption()) {
            this._options.add(newName, value);
        } else {
            this._options.put(newName, value);
        }
        this.putComment(newName);
    }

    @Override
    public void startOptions() {
        this.lastComments.clear();
    }

    protected static OptionsBuilder newInstance() {
        return ServiceFinder.findService(OptionsBuilder.class);
    }

    private Config getConfig() {
        return this._options.getConfig();
    }

    private void setFooterComment() {
        if (this.getConfig().isComment() && !this.lastComments.isEmpty()) {
            this._options.setFooterComment(this.lastComments);
        }
    }

    private void putComment(String key) {
        if (this.getConfig().isComment() && !this.lastComments.isEmpty()) {
            this._options.putComment(key, this.lastComments);
            this.lastComments = new LinkedList<String>();
        }
    }
}

