/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.izforge.izpack.util.Console;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class PacksConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private Messages messages;
    private HashMap<String, Pack> names;
    private final Prompt prompt;
    private final InstallData installData;

    public PacksConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel);
        this.prompt = prompt;
        this.installData = installData;
        try {
            this.messages = installData.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException exception) {
            this.messages = installData.getMessages();
        }
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.out(Prompt.Type.INFORMATION, "");
        LinkedList<Pack> selectedPacks = new LinkedList<Pack>();
        this.computePacks(installData.getAvailablePacks());
        for (String key : this.names.keySet()) {
            this.drawHelper(key, selectedPacks, installData);
        }
        this.out(Prompt.Type.INFORMATION, "Done!");
        installData.setSelectedPacks(selectedPacks);
        if (selectedPacks.size() == 0) {
            this.out(Prompt.Type.WARNING, "You have not selected any packs!");
            this.out(Prompt.Type.WARNING, "Are you sure you want to continue?");
        }
        return this.promptEndPanel(installData, console);
    }

    private void out(Prompt.Type type, String message) {
        this.prompt.message(type, message);
    }

    private void drawHelper(String pack, List<Pack> selectedPacks, InstallData installData) {
        boolean packConditionTrue;
        Pack p = this.names.get(pack);
        Boolean conditionSatisfied = this.checkCondition(installData, p);
        String packName = PackHelper.getPackName(p, this.messages);
        boolean required = p.isRequired();
        boolean bl = packConditionTrue = conditionSatisfied == null || conditionSatisfied != false;
        if (packConditionTrue) {
            if (required) {
                this.out(Prompt.Type.INFORMATION, "  [x] Pack '" + packName + "' required");
                selectedPacks.add(p);
            } else if (this.askUser("  [x] Include optional pack '" + packName + "'", Prompt.Option.YES)) {
                selectedPacks.add(p);
            }
        } else {
            this.out(Prompt.Type.INFORMATION, "  [ ] Pack '" + packName + "' not enabled");
        }
    }

    private Boolean checkCondition(InstallData installData, Pack pack) {
        if (pack.hasCondition()) {
            return installData.getRules().isConditionTrue(pack.getCondition());
        }
        return null;
    }

    private boolean askUser(String message, Prompt.Option defaultOption) {
        return Prompt.Option.YES == this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO, defaultOption);
    }

    private void computePacks(List<Pack> packs) {
        this.names = new HashMap();
        for (Pack pack : packs) {
            this.names.put(pack.getName(), pack);
        }
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new PacksPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

