/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionWithMultipleOperands;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.process.RefCondition;

public class OrCondition
extends ConditionWithMultipleOperands {
    private static final long serialVersionUID = 2215690518636768369L;
    protected transient RulesEngine rules;

    public OrCondition(RulesEngine rules) {
        this.rules = rules;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing element in condition \"" + this.getId() + "\"");
        }
        for (IXMLElement element : xmlcondition.getChildren()) {
            String type = element.getAttribute("type");
            if (type == null || type.equals("ref") && !RefCondition.isValidRefCondition(element)) {
                throw new Exception("Incorrect element specified in condition \"" + this.getId() + "\"");
            }
            this.nestedConditions.add(this.rules.createCondition(element));
        }
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        for (Condition condition : this.nestedConditions) {
            result = result || condition.isTrue();
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        for (Condition condition : this.nestedConditions) {
            details.append(condition.getDependenciesDetails());
            details.append("</li> OR <li>");
        }
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        for (Condition condition : this.nestedConditions) {
            IXMLElement left = this.rules.createConditionElement(condition, conditionRoot);
            condition.makeXMLData(left);
            conditionRoot.addChild(left);
        }
    }
}

