/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.verapdf.gui.tools.SettingsHelper;

class SettingsPanel
extends JPanel {
    private JButton okButton;
    private boolean ok;
    JDialog dialog;
    private JTextField numberOfFailed;
    private JTextField numberOfFailedDisplay;
    private JRadioButton valAndFeat;
    private JRadioButton val;
    private JRadioButton feat;
    private JCheckBox hidePassedRules;

    public SettingsPanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        ButtonGroup bGroup = new ButtonGroup();
        panel.setLayout(new GridLayout(6, 2));
        panel.add(new JPanel());
        this.valAndFeat = new JRadioButton("Validation & Features");
        bGroup.add(this.valAndFeat);
        panel.add(this.valAndFeat);
        panel.add(new JLabel("Generate reports: "));
        this.val = new JRadioButton("Validation");
        bGroup.add(this.val);
        panel.add(this.val);
        panel.add(new JPanel());
        this.feat = new JRadioButton("Features");
        bGroup.add(this.feat);
        panel.add(this.feat);
        panel.add(new JLabel("Include passed rules "));
        this.hidePassedRules = new JCheckBox();
        panel.add(this.hidePassedRules);
        panel.add(new JLabel("Maximum number of failed checks for rule: "));
        this.numberOfFailed = new JTextField();
        this.numberOfFailed.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailed, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(this.numberOfFailed);
        panel1.add(new JLabel("    (1 to 999999 or empty for unlimited)"));
        panel.add(panel1);
        panel.add(new JLabel("Maximum number of displayed failed checks for rule: "));
        this.numberOfFailedDisplay = new JTextField();
        this.numberOfFailedDisplay.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailedDisplay, true));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 0));
        panel2.add(this.numberOfFailedDisplay);
        panel2.add(new JLabel("    (0 to 999999 or empty for unlimited)"));
        panel.add(panel2);
        this.add((Component)panel, "Center");
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SettingsPanel.this.ok = true;
                SettingsPanel.this.dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SettingsPanel.this.dialog.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    public boolean showDialog(Component parent, String title, Properties prop) {
        this.ok = false;
        boolean dispPassedRulesBool = SettingsHelper.isDispPassedRules(prop);
        this.hidePassedRules.setSelected(dispPassedRulesBool);
        int numbOfFail = SettingsHelper.getNumbOfFail(prop);
        if (numbOfFail == -1) {
            this.numberOfFailed.setText("");
        } else {
            this.numberOfFailed.setText(String.valueOf(numbOfFail));
        }
        int numbOfFailDisp = SettingsHelper.getNumbOfFailDisp(prop);
        if (numbOfFailDisp == -1) {
            this.numberOfFailedDisplay.setText("");
        } else {
            this.numberOfFailedDisplay.setText(String.valueOf(numbOfFailDisp));
        }
        int type = SettingsHelper.getProcessingType(prop);
        switch (type) {
            case 3: {
                this.valAndFeat.setSelected(true);
                break;
            }
            case 1: {
                this.val.setSelected(true);
                break;
            }
            case 2: {
                this.feat.setSelected(true);
            }
        }
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        return this.ok;
    }

    private static KeyAdapter getKeyAdapter(final JTextField field, final boolean fromZero) {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (field.getText().length() == 6 && field.getSelectedText().length() == 0 && c != '\b' && c != '\u007f') {
                    e.consume();
                } else if (c == '0' && (!fromZero && field.getText().length() == 0 || field.getText().startsWith("0"))) {
                    e.consume();
                } else if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                    e.consume();
                } else {
                    super.keyTyped(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (field.getText().startsWith("0")) {
                    field.setText(field.getText().replaceFirst("0*", ""));
                    if (field.getText().length() == 0) {
                        if (fromZero) {
                            field.setText("0");
                        } else {
                            field.setText("");
                        }
                    }
                }
                super.keyReleased(e);
            }
        };
    }

    public int getProcessingType() {
        if (this.valAndFeat.isSelected()) {
            return 3;
        }
        if (this.val.isSelected()) {
            return 1;
        }
        return 2;
    }

    public boolean isDispPassedRules() {
        return this.hidePassedRules.isSelected();
    }

    public int getFailedChecksNumber() {
        String str = this.numberOfFailed.getText();
        return str.length() > 0 ? Integer.parseInt(str) : -1;
    }

    public int getFailedChecksDisplayNumber() {
        String str = this.numberOfFailedDisplay.getText();
        return str.length() > 0 ? Integer.parseInt(str) : -1;
    }
}

