/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.impl.pb.external.PBoxICCOutputProfile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;

public class PBoxPDOutputIntent
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDOutputIntent {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDOutputIntent.class);
    public static final String OUTPUT_INTENT_TYPE = "PDOutputIntent";
    public static final String DEST_PROFILE = "destProfile";

    public PBoxPDOutputIntent(PDOutputIntent simplePDObject) {
        super((COSObjectable)simplePDObject, OUTPUT_INTENT_TYPE);
    }

    public String getdestOutputProfileRef() {
        COSDictionary dictionary = (COSDictionary)this.simplePDObject.getCOSObject();
        COSBase item = dictionary.getItem(COSName.DEST_OUTPUT_PROFILE);
        if (item instanceof COSObject) {
            return String.valueOf(((COSObject)item).getObjectNumber()) + ' ' + ((COSObject)item).getGenerationNumber();
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (DEST_PROFILE.equals(link)) {
            return this.getDestProfile();
        }
        return super.getLinkedObjects(link);
    }

    private List<ICCOutputProfile> getDestProfile() {
        ArrayList<ICCOutputProfile> profile = new ArrayList<ICCOutputProfile>();
        COSBase dict = this.simplePDObject.getCOSObject();
        String subtype = null;
        if (dict instanceof COSDictionary) {
            subtype = ((COSDictionary)dict).getNameAsString(COSName.S);
        }
        try {
            COSStream dest = ((PDOutputIntent)this.simplePDObject).getDestOutputIntent();
            if (dest != null) {
                InputStream unfilteredStream = dest.getUnfilteredStream();
                long N = dest.getLong(COSName.N);
                profile.add(new PBoxICCOutputProfile(unfilteredStream, subtype, N != -1L ? Long.valueOf(N) : null));
                unfilteredStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((java.lang.Object)("Can not read dest output profile. " + e.getMessage()), (Throwable)e);
        }
        return profile;
    }
}

