/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.model.impl.pb.pd.PBoxPDAcroForm;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDOutline;
import org.verapdf.model.impl.pb.pd.PBoxPDOutputIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDPage;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.pdlayer.PDPage;

public class PBoxPDDocument
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDDocument {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDDocument.class);
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final int MAX_NUMBER_OF_ACTIONS = 5;
    public static final String PD_DOCUMENT_TYPE = "PDDocument";

    public PBoxPDDocument(PDDocument document) {
        super(document, PD_DOCUMENT_TYPE);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Outlines": {
                return this.getOutlines();
            }
            case "OpenAction": {
                return this.getOpenAction();
            }
            case "AA": {
                return this.getActions();
            }
            case "pages": {
                return this.getPages();
            }
            case "metadata": {
                return this.getMetadata();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "AcroForm": {
                return this.getAcroForms();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOutline> getOutlines() {
        ArrayList<PDOutline> result = new ArrayList<PDOutline>();
        List<PDOutlineItem> outlines = this.getOutlinesList();
        for (PDOutlineItem outlineItem : outlines) {
            result.add(new PBoxPDOutline(outlineItem));
        }
        outlines.clear();
        return result;
    }

    private List<PDOutlineItem> getOutlinesList() {
        ArrayList<PDOutlineItem> result = new ArrayList<PDOutlineItem>();
        PDDocumentOutline documentOutline = this.document.getDocumentCatalog().getDocumentOutline();
        if (documentOutline != null) {
            PDOutlineItem firstChild = documentOutline.getFirstChild();
            ArrayDeque<PDOutlineItem> stack = new ArrayDeque<PDOutlineItem>();
            if (firstChild != null) {
                stack.push(firstChild);
            }
            while (!stack.isEmpty()) {
                PDOutlineItem item = (PDOutlineItem)stack.pop();
                PDOutlineItem nextSibling = item.getNextSibling();
                firstChild = item.getFirstChild();
                if (nextSibling != null && !result.contains(nextSibling)) {
                    stack.add(nextSibling);
                }
                if (firstChild != null && !result.contains(firstChild)) {
                    stack.add(firstChild);
                }
                result.add(item);
            }
        }
        return result;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getOpenAction() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
        try {
            PDDestinationOrAction openAction = this.document.getDocumentCatalog().getOpenAction();
            if (openAction instanceof PDAction) {
                this.addAction(actions, (PDAction)openAction);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problems with open action obtaining. " + e.getMessage()), (Throwable)e);
        }
        return actions;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(5);
        PDDocumentCatalogAdditionalActions pbActions = this.document.getDocumentCatalog().getActions();
        if (pbActions != null) {
            PDAction buffer = pbActions.getDP();
            this.addAction(actions, buffer);
            buffer = pbActions.getDS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWP();
            this.addAction(actions, buffer);
            buffer = pbActions.getWS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWC();
            this.addAction(actions, buffer);
        }
        return actions;
    }

    private List<PDPage> getPages() {
        PDPageTree pageTree = this.document.getPages();
        ArrayList<PDPage> pages = new ArrayList<PDPage>(pageTree.getCount());
        for (org.apache.pdfbox.pdmodel.PDPage page : pageTree) {
            pages.add(new PBoxPDPage(page));
        }
        return pages;
    }

    private List<PDMetadata> getMetadata() {
        ArrayList<PDMetadata> metadata = new ArrayList<PDMetadata>(1);
        org.apache.pdfbox.pdmodel.common.PDMetadata meta = this.document.getDocumentCatalog().getMetadata();
        if (meta != null && meta.getCOSObject() != null) {
            metadata.add(new PBoxPDMetadata(meta, Boolean.TRUE));
        }
        return metadata;
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> getOutputIntents() {
        ArrayList<org.verapdf.model.pdlayer.PDOutputIntent> outputIntents = new ArrayList<org.verapdf.model.pdlayer.PDOutputIntent>();
        List pdfboxOutputIntents = this.document.getDocumentCatalog().getOutputIntents();
        for (PDOutputIntent intent : pdfboxOutputIntents) {
            if (intent == null) continue;
            outputIntents.add(new PBoxPDOutputIntent(intent));
        }
        return outputIntents;
    }

    private List<PDAcroForm> getAcroForms() {
        ArrayList<PDAcroForm> forms = new ArrayList<PDAcroForm>(1);
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form = this.document.getDocumentCatalog().getAcroForm();
        if (form != null) {
            forms.add(new PBoxPDAcroForm(form));
        }
        return forms;
    }
}

