/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.xmp;

import org.apache.log4j.Logger;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.PDFAExtensionSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.PhotoshopSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPMediaManagementSchema;
import org.apache.xmpbox.schema.XMPRightsManagementSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.schema.XMPageTextSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBAUXSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBCRSSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFAExtensionSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFAIdSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPhotoshopSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXAPSSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPBasicSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPCustomSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPDMSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPMMSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPPredefinedSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPRightsSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPTPgSchema;
import org.verapdf.model.tools.XMPHelper;

public final class PBSchemaFactory {
    private static final Logger LOGGER = Logger.getLogger(PBSchemaFactory.class);

    private PBSchemaFactory() {
    }

    public static PBXMPSchema createSchema(XMPSchema schema) {
        if (schema == null) {
            return null;
        }
        PBXMPSchema resultSchema = null;
        switch (schema.getNamespace()) {
            case "http://www.aiim.org/pdfa/ns/id/": {
                if (schema instanceof PDFAIdentificationSchema) {
                    resultSchema = new PBPDFAIdSchema((PDFAIdentificationSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("PDFAIdentificationSchema", "http://www.aiim.org/pdfa/ns/id/");
                break;
            }
            case "http://www.aiim.org/pdfa/ns/extension/": {
                if (schema instanceof PDFAExtensionSchema) {
                    resultSchema = new PBPDFAExtensionSchema((PDFAExtensionSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("PDFAExtensionSchema", "http://www.aiim.org/pdfa/ns/extension/");
                break;
            }
            case "http://ns.adobe.com/xap/1.0/": {
                if (schema instanceof XMPBasicSchema) {
                    resultSchema = new PBXMPBasicSchema((XMPBasicSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("XMPBasicSchema", "http://ns.adobe.com/xap/1.0/");
                break;
            }
            case "http://ns.adobe.com/xap/1.0/rights/": {
                if (schema instanceof XMPRightsManagementSchema) {
                    resultSchema = new PBXMPRightsSchema((XMPRightsManagementSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("XMPRightsManagementSchema", "http://ns.adobe.com/xap/1.0/rights/");
                break;
            }
            case "http://ns.adobe.com/xap/1.0/mm/": {
                if (schema instanceof XMPMediaManagementSchema) {
                    resultSchema = new PBXMPMMSchema((XMPMediaManagementSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("XMPMediaManagementSchema", "http://ns.adobe.com/xap/1.0/mm/");
                break;
            }
            case "http://ns.adobe.com/xap/1.0/t/pg/": {
                if (schema instanceof XMPageTextSchema) {
                    resultSchema = new PBXMPTPgSchema((XMPageTextSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("XMPageTextSchema", "http://ns.adobe.com/xap/1.0/t/pg/");
                break;
            }
            case "http://ns.adobe.com/pdf/1.3/": {
                if (schema instanceof AdobePDFSchema) {
                    resultSchema = new PBPDFSchema((AdobePDFSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("AdobePDFSchema", "http://ns.adobe.com/pdf/1.3/");
                break;
            }
            case "http://ns.adobe.com/photoshop/1.0/": {
                if (schema instanceof PhotoshopSchema) {
                    resultSchema = new PBPhotoshopSchema((PhotoshopSchema)schema);
                    break;
                }
                PBSchemaFactory.schemaExceptionMessage("PhotoshopSchema", "http://ns.adobe.com/photoshop/1.0/");
                break;
            }
            case "http://ns.adobe.com/camera-rawsettings/1.0/": {
                resultSchema = new PBCRSSchema(schema);
                break;
            }
            case "http://ns.adobe.com/exif/1.0/aux/": {
                resultSchema = new PBAUXSchema(schema);
                break;
            }
            case "http://ns.adobe.com/xmp/1.0/DynamicMedia/": {
                resultSchema = new PBXMPDMSchema(schema);
                break;
            }
            case "http://ns.adobe.com/xap/1.0/s/": {
                resultSchema = new PBXAPSSchema(schema);
                break;
            }
            default: {
                resultSchema = XMPHelper.isPredifinedSchema(schema.getNamespace()) ? new PBXMPPredefinedSchema(schema) : new PBXMPCustomSchema(schema);
            }
        }
        return resultSchema;
    }

    private static void schemaExceptionMessage(String className, String namespace) {
        LOGGER.fatal((Object)("Founded not " + className + "schema with namespace " + namespace));
    }
}

