/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDGroup;

public class PBoxPDGroup
extends PBoxPDObject
implements PDGroup {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDGroup.class);
    public static final String GROUP_TYPE = "PDGroup";
    public static final String COLOR_SPACE = "colorSpace";

    public PBoxPDGroup(org.apache.pdfbox.pdmodel.graphics.form.PDGroup simplePDObject) {
        super((COSObjectable)simplePDObject, GROUP_TYPE);
    }

    public String getS() {
        return ((org.apache.pdfbox.pdmodel.graphics.form.PDGroup)this.simplePDObject).getSubType().getName();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (COLOR_SPACE.equals(link)) {
            return this.getColorSpace();
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace() {
        ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
        try {
            PDColorSpace pbColorSpace = ((org.apache.pdfbox.pdmodel.graphics.form.PDGroup)this.simplePDObject).getColorSpace();
            org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(pbColorSpace);
            if (colorSpace != null) {
                colorSpaces.add(colorSpace);
            }
        }
        catch (IOException e) {
            LOGGER.error((java.lang.Object)("Problems with color space obtaining on group. " + e.getMessage()), (Throwable)e);
        }
        return colorSpaces;
    }
}

