/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;

public class GraphicState
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(GraphicState.class);
    private PDColorSpace fillColorSpace = PDDeviceGray.INSTANCE;
    private PDColorSpace strokeColorSpace = PDDeviceGray.INSTANCE;
    private PDAbstractPattern pattern = null;
    private RenderingMode renderingMode = RenderingMode.FILL;
    private PDFont font;

    public PDColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PDColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public PDColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PDColorSpace strokeColorSpace) {
        this.strokeColorSpace = strokeColorSpace;
    }

    public PDAbstractPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(PDAbstractPattern pattern) {
        this.pattern = pattern;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void copyProperties(GraphicState graphicState) {
        this.fillColorSpace = graphicState.getFillColorSpace();
        this.strokeColorSpace = graphicState.getStrokeColorSpace();
        this.pattern = graphicState.getPattern();
        this.renderingMode = graphicState.getRenderingMode();
        this.font = graphicState.getFont();
    }

    public void copyPropertiesFromExtGState(PDExtendedGraphicsState extGState) {
        if (extGState != null) {
            try {
                if (extGState.getFontSetting() != null) {
                    this.font = extGState.getFontSetting().getFont();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public GraphicState clone() throws CloneNotSupportedException {
        GraphicState graphicState = (GraphicState)super.clone();
        graphicState.fillColorSpace = this.fillColorSpace;
        graphicState.strokeColorSpace = this.strokeColorSpace;
        graphicState.pattern = this.pattern;
        graphicState.renderingMode = this.renderingMode;
        graphicState.font = this.font;
        return graphicState;
    }
}

