/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.font;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.verapdf.model.impl.pb.pd.font.PBoxPDTrueTypeFont;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType0Font;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType1Font;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType3Font;

public final class FontFactory {
    public static final String TYPE_0 = "Type0";
    public static final String TYPE_1 = "Type1";
    public static final String TYPE_3 = "Type3";
    public static final String TRUE_TYPE = "TrueType";
    public static final String CID_FONT_TYPE_2 = "CIDFontType2";

    private FontFactory() {
    }

    public static org.verapdf.model.pdlayer.PDFont parseFont(PDFont pdfboxFont) {
        switch (pdfboxFont.getSubType()) {
            case "Type0": {
                return new PBoxPDType0Font((PDFontLike)pdfboxFont);
            }
            case "Type1": {
                if (pdfboxFont instanceof PDType1Font) {
                    return new PBoxPDType1Font((PDType1Font)pdfboxFont);
                }
                if (pdfboxFont instanceof PDType1CFont) {
                    return new PBoxPDType1Font((PDType1CFont)pdfboxFont);
                }
            }
            case "Type3": {
                return new PBoxPDType3Font((PDFontLike)pdfboxFont);
            }
            case "TrueType": {
                return new PBoxPDTrueTypeFont((PDTrueTypeFont)pdfboxFont);
            }
        }
        return null;
    }
}

