/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBShadingFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShading shading;
    private String id;
    private String colorSpaceChild;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBShadingFeaturesObject(PDShading shading, String id, String colorSpaceChild, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.shading = shading;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.SHADING;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.shading != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("shading");
            root.addAttribute(ID, this.id);
            this.parseParents(root);
            FeatureTreeNode.newChildInstanceWithValue("shadingType", String.valueOf(this.shading.getShadingType()), root);
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shadingClr = FeatureTreeNode.newChildInstance("colorSpace", root);
                shadingClr.addAttribute(ID, this.colorSpaceChild);
            }
            PBCreateNodeHelper.addBoxFeature("bbox", this.shading.getBBox(), root);
            FeatureTreeNode.newChildInstanceWithValue("antiAlias", String.valueOf(this.shading.getAntiAlias()), root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.SHADING, root);
            return root;
        }
        return null;
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }
}

