/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBProcSetFeaturesObject
implements IFeaturesObject {
    private COSArray procSet;
    private String id;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBProcSetFeaturesObject(COSArray procSet, String id, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.procSet = procSet;
        this.id = id;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PROCSET;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.procSet != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("procSet");
            root.addAttribute("id", this.id);
            this.parseParents(root);
            for (int i = 0; i < this.procSet.size(); ++i) {
                if (!(this.procSet.get(i) instanceof COSName)) continue;
                FeatureTreeNode entry = FeatureTreeNode.newChildInstanceWithValue("entry", ((COSName)this.procSet.get(i)).getName(), root);
                entry.addAttribute("number", String.valueOf(i));
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PROCSET, root);
            return root;
        }
        return null;
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }
}

