/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBFormXObjectFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDFormXObject formXObject;
    private String id;
    private String groupColorSpaceChild;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> procSetChild;
    private Set<String> propertiesChild;
    private Set<String> pageParent;
    private Set<String> annotationParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBFormXObjectFeaturesObject(PDFormXObject formXObject, String id, String groupColorSpaceChild, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> procSetChild, Set<String> propertiesChild, Set<String> pageParent, Set<String> annotationParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.formXObject = formXObject;
        this.id = id;
        this.groupColorSpaceChild = groupColorSpaceChild;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.procSetChild = procSetChild;
        this.propertiesChild = propertiesChild;
        this.pageParent = pageParent;
        this.annotationParent = annotationParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.FORM_XOBJECT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.formXObject != null) {
            COSBase cosBase;
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("form");
            root.addAttribute(ID, this.id);
            this.parseParents(root);
            PBCreateNodeHelper.addBoxFeature("bbox", this.formXObject.getBBox(), root);
            PBFormXObjectFeaturesObject.parseFloatMatrix(this.formXObject.getMatrix().getValues(), FeatureTreeNode.newChildInstance("matrix", root));
            if (this.formXObject.getGroup() != null) {
                FeatureTreeNode groupNode = FeatureTreeNode.newChildInstance("group", root);
                if (this.formXObject.getGroup().getSubType() != null) {
                    PBCreateNodeHelper.addNotEmptyNode("subtype", this.formXObject.getGroup().getSubType().getName(), groupNode);
                    if ("Transparency".equals(this.formXObject.getGroup().getSubType().getName())) {
                        if (this.groupColorSpaceChild != null) {
                            FeatureTreeNode clr = FeatureTreeNode.newChildInstance("colorSpace", groupNode);
                            clr.addAttribute(ID, this.groupColorSpaceChild);
                        }
                        FeatureTreeNode.newChildInstanceWithValue("isolated", String.valueOf(this.formXObject.getGroup().isIsolated()), groupNode);
                        FeatureTreeNode.newChildInstanceWithValue("knockout", String.valueOf(this.formXObject.getGroup().isKnockout()), groupNode);
                    }
                }
            }
            if (this.formXObject.getCOSStream().getItem(COSName.STRUCT_PARENTS) != null) {
                FeatureTreeNode.newChildInstanceWithValue("structParents", String.valueOf(this.formXObject.getStructParents()), root);
            }
            if ((cosBase = this.formXObject.getCOSStream().getDictionaryObject(COSName.METADATA)) instanceof COSStream) {
                PDMetadata meta = new PDMetadata((COSStream)cosBase);
                PBCreateNodeHelper.parseMetadata(meta, "metadata", root, collection);
            }
            this.parseResources(root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.FORM_XOBJECT, root);
            return root;
        }
        return null;
    }

    private static void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
                element.addAttribute("row", String.valueOf(i + 1));
                element.addAttribute("column", String.valueOf(j + 1));
                element.addAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.annotationParent != null && !this.annotationParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.annotationParent, "annotation", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.procSetChild != null && !this.procSetChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.newChildInstance("resources", root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.procSetChild, "procSet", "procSets", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

