/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.model;

import java.util.Collections;
import java.util.List;
import org.verapdf.validation.profile.model.Fix;
import org.verapdf.validation.profile.model.Reference;
import org.verapdf.validation.profile.model.RuleError;

public final class Rule {
    private final String attrID;
    private final String attrObject;
    private final String description;
    private final String test;
    private final RuleError ruleError;
    private final Reference reference;
    private final List<Fix> fixes;

    public Rule(String attrID, String attrObject, String description, RuleError ruleError, String test, Reference reference, List<Fix> fixes) {
        if (attrID == null) {
            throw new IllegalArgumentException("Rule ID attrID can not be null.");
        }
        this.attrID = attrID;
        this.attrObject = attrObject;
        this.description = description;
        this.ruleError = ruleError;
        this.test = test;
        this.reference = reference;
        this.fixes = fixes == null ? Collections.emptyList() : Collections.unmodifiableList(fixes);
    }

    public String getAttrID() {
        return this.attrID;
    }

    public String getAttrObject() {
        return this.attrObject;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTest() {
        return this.test;
    }

    public RuleError getRuleError() {
        return this.ruleError;
    }

    public Reference getReference() {
        return this.reference;
    }

    public List<Fix> getFixes() {
        return this.fixes;
    }

    public String toString() {
        return "Rule [attrID=" + this.attrID + ", attrObject=" + this.attrObject + ", description=" + this.description + ", test=" + this.test + ", ruleError=" + this.ruleError + ", reference=" + this.reference + ", fixes=" + this.fixes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attrID.hashCode();
        result = 31 * result + (this.attrObject == null ? 0 : this.attrObject.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.fixes.hashCode();
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.ruleError == null ? 0 : this.ruleError.hashCode());
        result = 31 * result + (this.test == null ? 0 : this.test.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (!this.attrID.equals(other.attrID)) {
            return false;
        }
        if (this.attrObject == null ? other.attrObject != null : !this.attrObject.equals(other.attrObject)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.test == null ? other.test != null : !this.test.equals(other.test)) {
            return false;
        }
        if (!this.isEquals(other)) {
            return false;
        }
        if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
            return false;
        }
        return !(this.ruleError == null ? other.ruleError != null : !this.ruleError.equals(other.ruleError));
    }

    private boolean isEquals(Rule other) {
        return this.fixes.size() == other.fixes.size() && this.fixes.containsAll(other.fixes);
    }
}

