/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    private final CopyOnWriteArrayList<Appender> appenderList = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        CopyOnWriteArrayList<Appender> copyOnWriteArrayList = this.appenderList;
        synchronized (copyOnWriteArrayList) {
            if (!this.appenderList.contains(newAppender)) {
                this.appenderList.add(newAppender);
            }
        }
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int size = this.appenderList.size();
        for (Appender appender : this.appenderList) {
            appender.doAppend(event);
        }
        return size;
    }

    @Override
    public Enumeration getAllAppenders() {
        return new EnumerationFromIter(this.appenderList);
    }

    @Override
    public Appender getAppender(String name) {
        if (name == null) {
            return null;
        }
        for (Appender appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        for (Appender a : this.appenderList) {
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllAppenders() {
        for (Appender appender : this.appenderList) {
            appender.close();
        }
        this.appenderList.clear();
    }

    @Override
    public void removeAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        this.appenderList.remove(appender);
    }

    @Override
    public void removeAppender(String name) {
        if (name == null) {
            return;
        }
        for (Appender appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            this.appenderList.remove(appender);
            break;
        }
    }

    private static class EnumerationFromIter
    implements Enumeration {
        final Iterator iterator;

        private EnumerationFromIter(Iterable iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

