/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;

public class StandardColorSpaceHelper
implements ColorSpaceHelper {
    protected PreflightContext context = null;
    protected ICCProfileWrapper iccpw = null;
    protected PDColorSpace pdcs = null;

    protected StandardColorSpaceHelper(PreflightContext _context, PDColorSpace _cs) {
        this.context = _context;
        this.pdcs = _cs;
    }

    @Override
    public final void validate() throws ValidationException {
        if (this.pdcs == null) {
            throw new ValidationException("Unable to create a PDColorSpace with the value null");
        }
        this.iccpw = ICCProfileWrapper.getOrSearchICCProfile(this.context);
        this.processAllColorSpace(this.pdcs);
    }

    protected final void processAllColorSpace(PDColorSpace colorSpace) {
        ColorSpaces cs = ColorSpaces.valueOf(colorSpace.getName());
        switch (cs) {
            case DeviceRGB: 
            case DeviceRGB_SHORT: {
                this.processRGBColorSpace(colorSpace);
                break;
            }
            case DeviceCMYK: 
            case DeviceCMYK_SHORT: {
                this.processCYMKColorSpace(colorSpace);
                break;
            }
            case CalRGB: 
            case CalGray: 
            case Lab: {
                this.processCalibratedColorSpace(colorSpace);
                break;
            }
            case DeviceGray: 
            case DeviceGray_SHORT: {
                this.processGrayColorSpace(colorSpace);
                break;
            }
            case ICCBased: {
                this.processICCBasedColorSpace(colorSpace);
                break;
            }
            case DeviceN: {
                this.processDeviceNColorSpace(colorSpace);
                break;
            }
            case Indexed: 
            case Indexed_SHORT: {
                this.processIndexedColorSpace(colorSpace);
                break;
            }
            case Separation: {
                this.processSeparationColorSpace(colorSpace);
                break;
            }
            case Pattern: {
                this.processPatternColorSpace(colorSpace);
                break;
            }
            default: {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.4", cs.getLabel() + " is unknown as ColorSpace"));
            }
        }
    }

    protected void processRGBColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isRGBColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.1", "DestOutputProfile isn't RGB ColorSpace"));
            }
        }
    }

    protected void processCYMKColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isCMYKColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.2", "DestOutputProfile isn't CMYK ColorSpace"));
            }
        }
    }

    protected void processPatternColorSpace(PDColorSpace colorSpace) {
        if (this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processGrayColorSpace(PDColorSpace colorSpace) {
        if (!this.processDefaultColorSpace(colorSpace) && this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processCalibratedColorSpace(PDColorSpace colorSpace) {
    }

    protected void processICCBasedColorSpace(PDColorSpace colorSpace) {
        PDICCBased iccBased = (PDICCBased)colorSpace;
        try {
            ColorSpaces altCsId;
            ICC_Profile.getInstance(iccBased.getPDStream().createInputStream());
            PDColorSpace altpdcs = iccBased.getAlternateColorSpace();
            if (altpdcs != null && (altCsId = ColorSpaces.valueOf(altpdcs.getName())) == ColorSpaces.Pattern) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.5", "Pattern is forbidden as AlternateColorSpace of a ICCBased"));
            }
        }
        catch (IllegalArgumentException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.11", "ICCBased color space is invalid: " + e.getMessage(), e));
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read ICCBase color space: " + e.getMessage(), e));
        }
    }

    protected void processDeviceNColorSpace(PDColorSpace colorSpace) {
        PDDeviceN deviceN = (PDDeviceN)colorSpace;
        try {
            Map colorants;
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
                return;
            }
            COSBase cosAlt = ((COSArray)colorSpace.getCOSObject()).getObject(2);
            PDColorSpace altColor = PDColorSpace.create((COSBase)cosAlt);
            if (altColor != null) {
                this.processAllColorSpace(altColor);
            }
            int numberOfColorants = 0;
            PDDeviceNAttributes attr = deviceN.getAttributes();
            if (attr != null && (colorants = attr.getColorants()) != null) {
                numberOfColorants = colorants.size();
                for (PDSeparation col : colorants.values()) {
                    if (col == null) continue;
                    this.processAllColorSpace((PDColorSpace)col);
                }
            }
            int numberOfComponents = deviceN.getNumberOfComponents();
            if (numberOfColorants > 8 || numberOfComponents > 8) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.10", "DeviceN has too many tint components or colorants"));
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read DeviceN color space : " + e.getMessage(), e));
        }
    }

    protected void processIndexedColorSpace(PDColorSpace colorSpace) {
        PDIndexed indexed = (PDIndexed)colorSpace;
        PDColorSpace based = indexed.getBaseColorSpace();
        ColorSpaces cs = ColorSpaces.valueOf(based.getName());
        if (cs == ColorSpaces.Indexed || cs == ColorSpaces.Indexed_SHORT) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Indexed color space can't be used as Base color space"));
            return;
        }
        if (cs == ColorSpaces.Pattern) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Pattern color space can't be used as Base color space"));
            return;
        }
        this.processAllColorSpace(based);
    }

    protected void processSeparationColorSpace(PDColorSpace colorSpace) {
        try {
            COSBase cosAlt = ((COSArray)colorSpace.getCOSObject()).getObject(2);
            PDColorSpace altCol = PDColorSpace.create((COSBase)cosAlt);
            if (altCol != null) {
                ColorSpaces acs = ColorSpaces.valueOf(altCol.getName());
                switch (acs) {
                    case DeviceN: 
                    case Indexed: 
                    case Indexed_SHORT: 
                    case Separation: 
                    case Pattern: {
                        this.context.addValidationError(new ValidationResult.ValidationError("2.4.7", acs.getLabel() + " color space can't be used as alternate color space"));
                        break;
                    }
                    default: {
                        this.processAllColorSpace(altCol);
                    }
                }
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read Separation color space : " + e.getMessage(), e));
        }
    }

    protected boolean processDefaultColorSpace(PDColorSpace colorSpace) {
        boolean result = false;
        PreflightPath vPath = this.context.getValidationPath();
        PDResources resources = vPath.getClosestPathElement(PDResources.class);
        if (resources != null) {
            PDColorSpace defaultCS = null;
            try {
                if (colorSpace.getName().equals(ColorSpaces.DeviceCMYK.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_CMYK)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_CMYK);
                } else if (colorSpace.getName().equals(ColorSpaces.DeviceRGB.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_RGB)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_RGB);
                } else if (colorSpace.getName().equals(ColorSpaces.DeviceGray.getLabel()) && resources.hasColorSpace(COSName.DEFAULT_GRAY)) {
                    defaultCS = resources.getColorSpace(COSName.DEFAULT_GRAY);
                }
            }
            catch (IOException e) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read default color space : " + e.getMessage(), e));
            }
            if (defaultCS != null) {
                int nbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                this.processAllColorSpace(defaultCS);
                int newNbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                result = nbOfErrors == newNbOfErrors;
            }
        }
        return result;
    }
}

