/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXForm;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXImage;
import org.verapdf.model.pdlayer.PDXObject;

public class PBoxPDXObject
extends PBoxPDResources
implements PDXObject {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDXObject.class);
    public static final String X_OBJECT_TYPE = "PDXObject";
    public static final String OPI = "OPI";
    public static final String S_MASK = "SMask";

    public PBoxPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject simplePDObject) {
        super((COSObjectable)simplePDObject, X_OBJECT_TYPE);
    }

    protected PBoxPDXObject(COSObjectable simplePDObject, String type) {
        super(simplePDObject, type);
    }

    public String getSubtype() {
        COSStream dict = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        return this.getSubtypeString(dict.getDictionaryObject(COSName.SUBTYPE));
    }

    protected String getSubtypeString(COSBase item) {
        if (item instanceof COSString) {
            return ((COSString)item).getString();
        }
        if (item instanceof COSName) {
            return ((COSName)item).getName();
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "SMask": {
                return this.getSMask();
            }
            case "OPI": {
                return this.getOPI();
            }
        }
        return super.getLinkedObjects(link);
    }

    protected List<PDXObject> getSMask() {
        ArrayList<PDXObject> mask = new ArrayList<PDXObject>(1);
        try {
            PDXObject xObject;
            COSStream cosStream = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
            COSBase smaskDictionary = cosStream.getDictionaryObject(COSName.SMASK);
            if (smaskDictionary instanceof COSDictionary && (xObject = this.getXObject(smaskDictionary)) != null) {
                mask.add(xObject);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problems with obtaining SMask. " + e.getMessage()), (Throwable)e);
        }
        return mask;
    }

    private PDXObject getXObject(COSBase smaskDictionary) throws IOException {
        COSName name = ((COSDictionary)smaskDictionary).getCOSName(COSName.NAME);
        String nameAsString = name != null ? name.getName() : null;
        PDResources resources = null;
        if (this.simplePDObject instanceof PDFormXObject) {
            resources = ((PDFormXObject)this.simplePDObject).getResources();
        }
        org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject = org.apache.pdfbox.pdmodel.graphics.PDXObject.createXObject((COSBase)smaskDictionary, (String)nameAsString, resources);
        return PBoxPDXObject.getTypedPDXObject(pbObject);
    }

    public static PDXObject getTypedPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject) {
        if (pbObject instanceof PDFormXObject) {
            return new PBoxPDXForm((PDFormXObject)pbObject);
        }
        if (pbObject instanceof PDImageXObject) {
            return new PBoxPDXImage((PDImage)((PDImageXObject)pbObject));
        }
        if (pbObject instanceof PDPostScriptXObject) {
            return new PBoxPDXObject(pbObject);
        }
        return null;
    }

    protected List<CosDict> getOPI() {
        return this.getLinkToDictionary(OPI);
    }

    protected List<CosDict> getLinkToDictionary(String key) {
        ArrayList<CosDict> list = new ArrayList<CosDict>(1);
        COSStream object = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        COSBase item = object.getDictionaryObject(COSName.getPDFName((String)key));
        if (item instanceof COSDictionary) {
            list.add(new PBCosDict((COSDictionary)item));
        }
        return list;
    }
}

