/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDXImage;

public class PBoxPDXImage
extends PBoxPDXObject
implements PDXImage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDXImage.class);
    public static final String X_IMAGE_TYPE = "PDXImage";
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";

    public PBoxPDXImage(PDImage simplePDObject) {
        this(simplePDObject, X_IMAGE_TYPE);
    }

    public PBoxPDXImage(PDImage simplePDObject, String type) {
        super((COSObjectable)simplePDObject, type);
    }

    public Boolean getInterpolate() {
        return ((PDImage)this.simplePDObject).getInterpolate();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "Alternates": {
                return this.getAlternates();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosRenderingIntent> getIntent() {
        ArrayList<CosRenderingIntent> intents = new ArrayList<CosRenderingIntent>(1);
        COSDictionary imageStream = (COSDictionary)this.simplePDObject.getCOSObject();
        COSName intent = imageStream.getCOSName(COSName.getPDFName((String)INTENT));
        if (intent != null) {
            intents.add(new PBCosRenderingIntent(intent));
        }
        return intents;
    }

    private List<PDColorSpace> getImageCS() {
        ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
        try {
            PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((PDImage)this.simplePDObject).getColorSpace());
            if (buffer != null) {
                colorSpaces.add(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problems with color space obtaining from Image XObject. " + e.getMessage()), (Throwable)e);
        }
        return colorSpaces;
    }

    protected List getAlternates() {
        ArrayList<PDXImage> alternates = new ArrayList<PDXImage>();
        COSStream imageStream = ((PDImageXObject)this.simplePDObject).getCOSStream();
        COSBase buffer = imageStream.getDictionaryObject(COSName.getPDFName((String)ALTERNATES));
        this.addAlternates(alternates, buffer, ((PDImageXObject)this.simplePDObject).getResources());
        return alternates;
    }

    private void addAlternates(List<PDXImage> alternates, COSBase buffer, PDResources resources) {
        if (buffer instanceof COSArray) {
            for (COSBase element : (COSArray)buffer) {
                if (element instanceof COSObject) {
                    element = ((COSObject)element).getObject();
                }
                if (!(element instanceof COSDictionary)) continue;
                this.addAlternate(alternates, (COSDictionary)element, resources);
            }
        }
    }

    private void addAlternate(List<PDXImage> alternates, COSDictionary buffer, PDResources resources) {
        COSBase alternatesImages = buffer.getDictionaryObject(COSName.IMAGE);
        if (alternatesImages instanceof COSStream) {
            try {
                PDStream stream = new PDStream((COSStream)alternatesImages);
                PDImageXObject imageXObject = new PDImageXObject(stream, resources);
                alternates.add(new PBoxPDXImage((PDImage)imageXObject));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in creating Alternate XObject. " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

