/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.impl.pb.cos.PBCosDocument;

public final class ModelLoader
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ModelLoader.class);
    private File file;
    private PDDocument document;

    public ModelLoader(String path) {
        this.file = new File(path);
    }

    public PDDocument getPDDocument() throws IOException {
        if (this.document == null) {
            if (!this.file.exists() || !this.file.isFile()) {
                LOGGER.error((Object)("Invalid path to document '" + this.file.getPath() + "'. File does not exist or not a file."));
            } else {
                this.document = PDDocument.load((File)this.file, (boolean)false, (boolean)true);
            }
        }
        return this.document;
    }

    public CosDocument getRoot() throws IOException {
        if (this.document == null) {
            this.document = this.getPDDocument();
        }
        return this.document != null ? new PBCosDocument(this.document, this.file.length()) : null;
    }

    @Override
    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problems with close document '" + this.file.getAbsolutePath() + "'."), (Throwable)e);
        }
    }
}

