/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.report.XMLFeaturesReport;
import org.verapdf.report.XMLValidationReport;
import org.verapdf.validation.report.model.ValidationInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLReport {
    private static final Logger LOGGER = Logger.getLogger(XMLReport.class);
    private static final long MS_IN_SEC = 1000L;
    private static final int SEC_IN_MIN = 60;
    private static final long MS_IN_MIN = 60000L;
    private static final int MIN_IN_HOUR = 60;
    private static final long MS_IN_HOUR = 3600000L;

    private XMLReport() {
    }

    private static String getProcessingTimeAsString(long processTime) {
        String res;
        long processingTime = processTime;
        Long hours = processingTime / 3600000L;
        Long mins = (processingTime %= 3600000L) / 60000L;
        Long sec = (processingTime %= 60000L) / 1000L;
        Long ms = processingTime %= 1000L;
        try (Formatter formatter = new Formatter();){
            formatter.format("%02d:", hours);
            formatter.format("%02d:", mins);
            formatter.format("%02d.", sec);
            formatter.format("%03d", ms);
            res = formatter.toString();
        }
        return res;
    }

    public static Element makeXMLTree(ValidationInfo info, FeaturesCollection collection, Document doc, long processingTimeInMS, boolean isLogPassedChecks) throws DatatypeConfigurationException {
        Element report = doc.createElement("report");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        XMLGregorianCalendar now = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        report.setAttribute("creationDateTime", now.toXMLFormat());
        report.setAttribute("processingTime", XMLReport.getProcessingTimeAsString(processingTimeInMS));
        report.appendChild(doc.createElement("documentInfo"));
        report.appendChild(doc.createElement("processingInfo"));
        if (info != null) {
            report.appendChild(XMLValidationReport.makeXMLTree(info, doc, isLogPassedChecks));
        }
        if (collection != null) {
            report.appendChild(XMLFeaturesReport.makeXMLTree(collection, doc));
        }
        return report;
    }

    private static Document generateDOMDocument(ValidationInfo info, FeaturesCollection collection, long processingTimeInMS, boolean isLogPassedChecks) throws ParserConfigurationException, DatatypeConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(XMLReport.makeXMLTree(info, collection, doc, processingTimeInMS, isLogPassedChecks));
        return doc;
    }

    private static void transform(Document doc, StreamResult outputTarget) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), outputTarget);
    }

    public static void writeXMLReport(ValidationInfo info, String path, long processingTimeInMS, boolean isLogPassedChecks) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, DatatypeConfigurationException {
        XMLReport.writeXMLReport(info, null, path, processingTimeInMS, isLogPassedChecks);
    }

    public static void writeXMLReport(ValidationInfo info, FeaturesCollection collection, String path, long processingTimeInMS, boolean isLogPassedChecks) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, DatatypeConfigurationException {
        Document doc = XMLReport.generateDOMDocument(info, collection, processingTimeInMS, isLogPassedChecks);
        try (FileOutputStream fos = new FileOutputStream(path);){
            XMLReport.transform(doc, new StreamResult(fos));
        }
        catch (IOException excep) {
            LOGGER.debug((Object)"Failed to close FileOutputStream fos.", (Throwable)excep);
        }
    }

    public static String getXMLReportAsString(ValidationInfo info, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, DatatypeConfigurationException {
        return XMLReport.getXMLReportAsString(info, null, processingTimeInMS);
    }

    public static String getXMLReportAsString(ValidationInfo info, FeaturesCollection collection, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, DatatypeConfigurationException {
        Document doc = XMLReport.generateDOMDocument(info, collection, processingTimeInMS, false);
        StringWriter writer = new StringWriter();
        XMLReport.transform(doc, new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

