/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui.tools;

import java.util.Properties;
import org.verapdf.gui.tools.GUIConstants;

public final class SettingsHelper {
    private SettingsHelper() {
    }

    public static int getProcessingType(Properties settings) {
        int type;
        if (settings == null) {
            return Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("processingType"));
        }
        try {
            type = Integer.parseInt(settings.getProperty("processingType"));
            if (type < 1 || type > 3) {
                type = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("processingType"));
            }
        }
        catch (NumberFormatException e) {
            type = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("processingType"));
        }
        return type;
    }

    public static int getNumbOfFailDisp(Properties settings) {
        int numbOfFailDisp;
        if (settings == null) {
            return Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbDisplFailedChecks"));
        }
        try {
            numbOfFailDisp = Integer.parseInt(settings.getProperty("maxNumbDisplFailedChecks"));
            if (numbOfFailDisp <= 0) {
                numbOfFailDisp = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbDisplFailedChecks"));
            }
        }
        catch (NumberFormatException e) {
            numbOfFailDisp = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbDisplFailedChecks"));
        }
        return numbOfFailDisp;
    }

    public static int getNumbOfFail(Properties settings) {
        int numbOfFail;
        if (settings == null) {
            return Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbFailedChecks"));
        }
        try {
            numbOfFail = Integer.parseInt(settings.getProperty("maxNumbFailedChecks"));
            if (numbOfFail <= 0) {
                numbOfFail = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbFailedChecks"));
            }
        }
        catch (NumberFormatException e) {
            numbOfFail = Integer.parseInt(GUIConstants.DEFAULT_PROPERTIES.getProperty("maxNumbFailedChecks"));
        }
        return numbOfFail;
    }

    public static boolean isDispPassedRules(Properties settings) {
        if (settings == null) {
            return Boolean.getBoolean(GUIConstants.DEFAULT_PROPERTIES.getProperty("hidePassedRules").toLowerCase());
        }
        String dispProp = settings.getProperty("hidePassedRules");
        boolean dispPassedRulesBool = "true".equals(dispProp.toLowerCase()) ? true : ("false".equals(dispProp.toLowerCase()) ? false : Boolean.getBoolean(GUIConstants.DEFAULT_PROPERTIES.getProperty("hidePassedRules").toLowerCase()));
        return dispPassedRulesBool;
    }
}

