/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.verapdf.gui.AboutPanel;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.MiniLogoPanel;
import org.verapdf.gui.SettingsPanel;
import org.verapdf.gui.tools.GUIConstants;

public class PDFValidationApplication
extends JFrame {
    private static final long serialVersionUID = -5569669411392145783L;
    private static final Logger LOGGER = Logger.getLogger(PDFValidationApplication.class);
    private AboutPanel aboutPanel;
    private Properties settings;
    private SettingsPanel settingsPanel;
    private CheckerPanel checkerPanel;

    public PDFValidationApplication() {
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 550, 350);
        this.setResizable(false);
        this.setTitle("PDF/A Conformance Checker");
        this.loadSettings();
        JMenuBar menuBar = new JMenuBar();
        menuBar.setLayout(new FlowLayout(0, 0, 0));
        this.setJMenuBar(menuBar);
        this.aboutPanel = null;
        try {
            this.aboutPanel = new AboutPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in reading logo image.", "Error", 0);
            LOGGER.error((Object)"Exception in reading logo image: ", (Throwable)e);
        }
        this.settingsPanel = new SettingsPanel();
        JMenuItem sett = new JMenuItem("Settings");
        sett.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.settingsPanel != null && PDFValidationApplication.this.settingsPanel.showDialog(PDFValidationApplication.this, "Settings", PDFValidationApplication.this.settings)) {
                    PDFValidationApplication.this.settings.setProperty("processingType", String.valueOf(PDFValidationApplication.this.settingsPanel.getProcessingType()));
                    PDFValidationApplication.this.settings.setProperty("hidePassedRules", String.valueOf(PDFValidationApplication.this.settingsPanel.isDispPassedRules()));
                    PDFValidationApplication.this.settings.setProperty("maxNumbFailedChecks", String.valueOf(PDFValidationApplication.this.settingsPanel.getFailedChecksNumber()));
                    PDFValidationApplication.this.settings.setProperty("maxNumbDisplFailedChecks", String.valueOf(PDFValidationApplication.this.settingsPanel.getFailedChecksDisplayNumber()));
                    PDFValidationApplication.this.saveSettings();
                    if (PDFValidationApplication.this.checkerPanel != null) {
                        PDFValidationApplication.this.checkerPanel.setSettings(PDFValidationApplication.this.settings);
                    }
                }
            }
        });
        menuBar.add(sett);
        JMenuItem about = new JMenuItem("About");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.aboutPanel != null) {
                    PDFValidationApplication.this.aboutPanel.showDialog(PDFValidationApplication.this, "About veraPDF");
                }
            }
        });
        menuBar.add(about);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.setContentPane(contentPane);
        MiniLogoPanel logoPanel = null;
        try {
            logoPanel = new MiniLogoPanel("veraPDF-logo-600.png");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in creating mini logo.", "Error", 0);
            LOGGER.error((Object)"Exception in creating mini logo: ", (Throwable)e);
        }
        contentPane.add(logoPanel);
        this.checkerPanel = null;
        try {
            this.checkerPanel = new CheckerPanel(this.settings);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in loading xml or html image.", "Error", 0);
            LOGGER.error((Object)"Exception in loading xml or html image: ", (Throwable)e);
        }
        contentPane.add(this.checkerPanel);
    }

    private void loadSettings() {
        File configFile = new File("./temp/config.properties");
        this.settings = new Properties(GUIConstants.DEFAULT_PROPERTIES);
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                this.settings.load(reader);
                reader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Couldn't load config file", (Throwable)e);
            }
        }
    }

    private void saveSettings() {
        File configFile = new File("./temp/config.properties");
        try {
            FileWriter writer = new FileWriter(configFile);
            this.settings.store(writer, "settings");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Couldn't save config into file", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    LOGGER.error((Object)"Exception in configuring UI manager: ", (Throwable)e);
                }
                try {
                    PDFValidationApplication frame = new PDFValidationApplication();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception: ", (Throwable)e);
                }
            }
        });
    }
}

