/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.exceptions.validationlogic.MultiplyGlobalVariableNameException;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.WrongSignatureException;
import org.verapdf.validation.profile.model.Fix;
import org.verapdf.validation.profile.model.Reference;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.RuleError;
import org.verapdf.validation.profile.model.ValidationProfile;
import org.verapdf.validation.profile.model.Variable;
import org.verapdf.validation.profile.parser.ValidationProfileSignatureChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ValidationProfileParser {
    private static final String ARGUMENT = "argument";
    private static final String CLAUSE = "clause";
    private static final String CREATED = "created";
    private static final String CREATOR = "creator";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String DESCRIPTION = "description";
    private static final String ERROR = "error";
    private static final String FIX = "fix";
    private static final String HASH = "hash";
    private static final String ID = "id";
    private static final String IMPORT = "import";
    private static final String IMPORTS = "imports";
    private static final String INFO = "info";
    private static final String MESSAGE = "message";
    private static final String MODEL = "model";
    private static final String NAME = "name";
    private static final String OBJECT = "object";
    private static final String REFERENCE = "reference";
    private static final String RULE = "rule";
    private static final String RULES = "rules";
    private static final String SPECIFICATION = "specification";
    private static final String TEST = "test";
    private static final String VALUE = "value";
    private static final String VARIABLES = "variables";
    private static final String VARIABLE = "variable";
    private static final String WARNING = "warning";
    private Set<String> profilesPaths = new HashSet<String>();
    private Set<String> variables = new HashSet<String>();
    private ValidationProfile profile;
    private DocumentBuilder builder;
    private File resource;

    private ValidationProfileParser(File resourceFile, boolean isSignCheckOn) throws ParserConfigurationException, IOException, SAXException, XMLStreamException, MissedHashTagException, WrongSignatureException, MultiplyGlobalVariableNameException {
        ValidationProfileSignatureChecker checker;
        this.resource = resourceFile;
        if (isSignCheckOn && !(checker = ValidationProfileSignatureChecker.newInstance(this.resource)).isValidSignature()) {
            throw new WrongSignatureException("Unsigned validation profile: " + this.resource.getCanonicalPath());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
        factory.setIgnoringElementContentWhitespace(true);
        Document doc = this.builder.parse(this.resource);
        this.profilesPaths.add(resourceFile.getCanonicalPath());
        Element root = doc.getDocumentElement();
        root.normalize();
        this.parseRoot(root, isSignCheckOn);
    }

    private void parseRoot(Node root, boolean isSignCheckOn) throws IOException, SAXException, MultiplyGlobalVariableNameException {
        String model = null;
        String name = null;
        String description = null;
        String creator = null;
        String created = null;
        String hash = null;
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        HashMap<String, List<Variable>> variables = new HashMap<String, List<Variable>>();
        Node modelNode = root.getAttributes().getNamedItem(MODEL);
        if (modelNode != null) {
            model = modelNode.getNodeValue();
        }
        NodeList children = root.getChildNodes();
        block20: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "name": {
                    name = child.getTextContent().trim();
                    continue block20;
                }
                case "description": {
                    description = child.getTextContent().trim();
                    continue block20;
                }
                case "creator": {
                    creator = child.getTextContent().trim();
                    continue block20;
                }
                case "created": {
                    created = child.getTextContent().trim();
                    continue block20;
                }
                case "hash": {
                    if (!isSignCheckOn) continue block20;
                    hash = child.getTextContent().trim();
                    continue block20;
                }
                case "imports": {
                    this.parseImports(this.resource, child, rules);
                    continue block20;
                }
                case "rules": {
                    ValidationProfileParser.parseRules(child, rules);
                    continue block20;
                }
                case "variables": {
                    this.parseVariables(child, variables);
                    continue block20;
                }
            }
        }
        this.profile = new ValidationProfile(model, name, description, creator, created, hash, rules, variables);
    }

    private void parseImports(File sourceFile, Node imports, Map<String, List<Rule>> rules) throws SAXException, IOException {
        NodeList children = imports.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(IMPORT)) continue;
            String path = child.getTextContent().trim();
            File newFile = new File(sourceFile.getParent(), path);
            if (!newFile.exists()) {
                throw new FileNotFoundException("Can not find import with path \"" + path + "\" directly to the given profile.");
            }
            if (this.profilesPaths.contains(newFile.getCanonicalPath())) continue;
            this.profilesPaths.add(newFile.getCanonicalPath());
            Document doc = this.builder.parse(newFile);
            NodeList children2 = doc.getDocumentElement().getChildNodes();
            block9: for (int j = 0; j < children2.getLength(); ++j) {
                String name;
                Node child2 = children2.item(j);
                switch (name = child2.getNodeName()) {
                    case "rules": {
                        ValidationProfileParser.parseRules(child2, rules);
                        continue block9;
                    }
                    case "imports": {
                        this.parseImports(newFile, child2, rules);
                        continue block9;
                    }
                }
            }
        }
    }

    private static void parseRules(Node rules, Map<String, List<Rule>> rulesMap) {
        NodeList children = rules.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!RULE.equals(child.getNodeName())) continue;
            Rule rule = ValidationProfileParser.parseRule(child);
            if (!rulesMap.containsKey(rule.getAttrObject())) {
                rulesMap.put(rule.getAttrObject(), new ArrayList());
            }
            rulesMap.get(rule.getAttrObject()).add(rule);
        }
    }

    private static Rule parseRule(Node rule) {
        Node objectNode;
        String id = null;
        String object = null;
        String description = null;
        String test = null;
        RuleError ruleError = null;
        Reference reference = null;
        ArrayList<Fix> fix = new ArrayList<Fix>();
        Node idNode = rule.getAttributes().getNamedItem(ID);
        if (idNode != null) {
            id = idNode.getNodeValue();
        }
        if ((objectNode = rule.getAttributes().getNamedItem(OBJECT)) != null) {
            object = objectNode.getNodeValue();
        }
        NodeList children = rule.getChildNodes();
        block16: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeName()) {
                case "description": {
                    description = child.getTextContent().trim();
                    continue block16;
                }
                case "test": {
                    test = child.getTextContent().trim();
                    continue block16;
                }
                case "error": {
                    ruleError = ValidationProfileParser.parseRuleError(child);
                    continue block16;
                }
                case "warning": {
                    ruleError = ValidationProfileParser.parseRuleError(child);
                    continue block16;
                }
                case "reference": {
                    reference = ValidationProfileParser.parseReference(child);
                    continue block16;
                }
                case "fix": {
                    fix.add(ValidationProfileParser.parseFix(child));
                    continue block16;
                }
            }
        }
        return new Rule(id, object, description, ruleError, test, reference, fix);
    }

    private void parseVariables(Node rules, Map<String, List<Variable>> variablesMap) throws MultiplyGlobalVariableNameException {
        NodeList children = rules.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(VARIABLE)) continue;
            Variable variable = this.parseVariable(child);
            if (variablesMap.get(variable.getAttrObject()) == null) {
                ArrayList newVariables = new ArrayList();
                variablesMap.put(variable.getAttrObject(), newVariables);
            }
            variablesMap.get(variable.getAttrObject()).add(variable);
        }
    }

    private Variable parseVariable(Node rule) throws MultiplyGlobalVariableNameException {
        String name = null;
        String object = null;
        String defaultValue = null;
        String value = null;
        Node nameNode = rule.getAttributes().getNamedItem(NAME);
        if (nameNode != null) {
            name = nameNode.getNodeValue();
        }
        if (this.variables.contains(name)) {
            throw new MultiplyGlobalVariableNameException("Founded multiply variable with name: " + name + "\".");
        }
        Node objectNode = rule.getAttributes().getNamedItem(OBJECT);
        if (objectNode != null) {
            object = objectNode.getNodeValue();
        }
        NodeList children = rule.getChildNodes();
        block8: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "defaultValue": {
                    defaultValue = child.getTextContent().trim();
                    continue block8;
                }
                case "value": {
                    value = child.getTextContent().trim();
                    continue block8;
                }
            }
        }
        return new Variable(name, object, defaultValue, value);
    }

    private static RuleError parseRuleError(Node err) {
        String message = null;
        ArrayList<String> argument = new ArrayList<String>();
        NodeList children = err.getChildNodes();
        block8: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "message": {
                    message = child.getTextContent().trim();
                    continue block8;
                }
                case "argument": {
                    argument.add(child.getTextContent().trim());
                    continue block8;
                }
            }
        }
        return new RuleError(message, argument);
    }

    private static Reference parseReference(Node ref) {
        String specification = null;
        String clause = null;
        ArrayList<Reference> references = new ArrayList<Reference>();
        NodeList children = ref.getChildNodes();
        block10: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "specification": {
                    specification = child.getTextContent().trim();
                    continue block10;
                }
                case "clause": {
                    clause = child.getTextContent().trim();
                    continue block10;
                }
                case "reference": {
                    references.add(ValidationProfileParser.parseReference(child));
                    continue block10;
                }
            }
        }
        return new Reference(specification, clause, references);
    }

    private static Fix parseFix(Node fix) {
        String id = null;
        String description = null;
        String info = null;
        String error = null;
        Node idNode = fix.getAttributes().getNamedItem(ID);
        if (idNode != null) {
            id = idNode.getNodeValue();
        }
        NodeList children = fix.getChildNodes();
        block10: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "description": {
                    description = child.getTextContent().trim();
                    continue block10;
                }
                case "info": {
                    NodeList descendants = child.getChildNodes();
                    info = ValidationProfileParser.getFirstMessageNodeTextContent(descendants);
                    continue block10;
                }
                case "error": {
                    NodeList descendants = child.getChildNodes();
                    error = ValidationProfileParser.getFirstMessageNodeTextContent(descendants);
                    continue block10;
                }
            }
        }
        return new Fix(id, description, info, error);
    }

    private static String getFirstMessageNodeTextContent(NodeList nodeList) {
        for (int j = 0; j < nodeList.getLength(); ++j) {
            if (!MESSAGE.equals(nodeList.item(j).getNodeName())) continue;
            return nodeList.item(j).getTextContent().trim();
        }
        return null;
    }

    public static ValidationProfile parseFromFilePath(String profileFilePath, boolean isSignCheckOn) throws ParserConfigurationException, SAXException, IOException, MissedHashTagException, XMLStreamException, WrongSignatureException, MultiplyGlobalVariableNameException {
        if (profileFilePath == null) {
            throw new IllegalArgumentException("Parameter (String profileFilePath) can not be null");
        }
        if (profileFilePath.isEmpty()) {
            throw new IllegalArgumentException("Parameter (String profileFilePath) can not be an empty String");
        }
        return ValidationProfileParser.parseFromFile(new File(profileFilePath), isSignCheckOn);
    }

    public static ValidationProfile parseFromFile(File profileFile, boolean isSignCheckOn) throws ParserConfigurationException, SAXException, IOException, MissedHashTagException, XMLStreamException, WrongSignatureException, MultiplyGlobalVariableNameException {
        if (profileFile == null) {
            throw new IllegalArgumentException("Parameter (File resourceFile) can not be null");
        }
        if (!profileFile.isFile()) {
            throw new IllegalArgumentException("Parameter (File resourceFile) must be an existing file.");
        }
        return new ValidationProfileParser((File)profileFile, (boolean)isSignCheckOn).profile;
    }
}

