/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.Variable;

public class ValidationProfile {
    private final String model;
    private final String name;
    private final String description;
    private final String creator;
    private final String created;
    private final String hash;
    private final Map<String, List<Rule>> rules;
    private final Map<String, List<Variable>> variables;

    public ValidationProfile(String model, String name, String description, String creator, String created, String hash, Map<String, List<Rule>> rules, Map<String, List<Variable>> variables) {
        this.model = model;
        this.name = name;
        this.description = description;
        this.creator = creator;
        this.created = created;
        this.hash = hash;
        this.rules = Collections.unmodifiableMap(rules);
        this.variables = Collections.unmodifiableMap(variables);
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreated() {
        return this.created;
    }

    public String getHash() {
        return this.hash;
    }

    public List<Rule> getRoolsForObject(String objName) {
        return this.rules.get(objName);
    }

    public Rule getRuleById(String id) {
        if (id == null || this.rules == null) {
            return null;
        }
        for (List<Rule> ruleList : this.rules.values()) {
            for (Rule rule : ruleList) {
                if (rule == null || !id.equals(rule.getAttrID())) continue;
                return rule;
            }
        }
        return null;
    }

    public List<String> getAllRulesId() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.rules == null) {
            return result;
        }
        for (List<Rule> ruleList : this.rules.values()) {
            for (Rule rule : ruleList) {
                if (rule == null) continue;
                result.add(rule.getAttrID());
            }
        }
        return result;
    }

    public List<Variable> getVariablesForObject(String objName) {
        if (this.variables != null && this.variables.get(objName) != null) {
            return this.variables.get(objName);
        }
        return new ArrayList<Variable>();
    }

    public List<Variable> getAllVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (this.variables != null) {
            for (List<Variable> variablesList : this.variables.values()) {
                result.addAll(variablesList);
            }
        }
        return result;
    }
}

