/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutputIntentsFeaturesObject
implements IFeaturesObject {
    private PDOutputIntent outInt;
    private String id;
    private String iccProfileID;

    public PBOutputIntentsFeaturesObject(PDOutputIntent outInt, String id, String iccProfileID) {
        this.outInt = outInt;
        this.id = id;
        this.iccProfileID = iccProfileID;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTPUTINTENT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.outInt != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("outputIntent");
            root.addAttribute("id", this.id);
            this.addSubtype(collection, root);
            PBCreateNodeHelper.addNotEmptyNode("outputCondition", this.outInt.getOutputCondition(), root);
            PBCreateNodeHelper.addNotEmptyNode("outputConditionIdentifier", this.outInt.getOutputConditionIdentifier(), root);
            PBCreateNodeHelper.addNotEmptyNode("registryName", this.outInt.getRegistryName(), root);
            PBCreateNodeHelper.addNotEmptyNode("info", this.outInt.getInfo(), root);
            FeatureTreeNode destOutInt = FeatureTreeNode.newChildInstance("destOutputIntent", root);
            destOutInt.addAttribute("id", this.iccProfileID);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTPUTINTENT, root);
            return root;
        }
        return null;
    }

    private void addSubtype(FeaturesCollection collection, FeatureTreeNode root) throws FeaturesTreeNodeException {
        COSBase base = this.outInt.getCOSObject();
        if (base instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)base;
            COSBase baseType = dict.getDictionaryObject(COSName.S);
            while (baseType instanceof COSObject) {
                baseType = ((COSObject)baseType).getObject();
            }
            if (baseType != null) {
                FeatureTreeNode type = FeatureTreeNode.newChildInstance("subtype", root);
                if (baseType instanceof COSName) {
                    type.setValue(((COSName)baseType).getName());
                } else {
                    type.addAttribute("errorID", "outinterr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "outinterr1", "In OutputIntent dictionary value for key \"S\" must be of type CosName.");
                }
            }
        }
    }
}

