/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutlinesFeaturesObject
implements IFeaturesObject {
    private static final int RGB_COLORS_NUMBER = 3;
    private static final int RGB_RED_COLOR_NUMBER = 0;
    private static final int RGB_GREEN_COLOR_NUMBER = 1;
    private static final int RGB_BLUE_COLOR_NUMBER = 2;
    private PDDocumentOutline outline;

    public PBOutlinesFeaturesObject(PDDocumentOutline outline) {
        this.outline = outline;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTLINES;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.outline != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("outlines");
            if (this.outline.children() != null) {
                HashSet<PDOutlineItem> items = new HashSet<PDOutlineItem>();
                for (PDOutlineItem item : this.outline.children()) {
                    if (items.contains(item)) continue;
                    PBOutlinesFeaturesObject.createItem(item, root, collection, items);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTLINES, root);
            return root;
        }
        return null;
    }

    private static void createItem(PDOutlineItem item, FeatureTreeNode root, FeaturesCollection collection, Set<PDOutlineItem> items) throws FeaturesTreeNodeException {
        if (item != null) {
            items.add(item);
            FeatureTreeNode itemNode = FeatureTreeNode.newChildInstance("outline", root);
            PBCreateNodeHelper.addNotEmptyNode("title", item.getTitle(), itemNode);
            if (item.getTextColor() != null) {
                FeatureTreeNode color = FeatureTreeNode.newChildInstance("color", itemNode);
                PDColor clr = item.getTextColor();
                float[] rgb = clr.getComponents();
                if (rgb.length == 3) {
                    FeatureTreeNode.newChildInstanceWithValue("red", String.valueOf(rgb[0]), color);
                    FeatureTreeNode.newChildInstanceWithValue("green", String.valueOf(rgb[1]), color);
                    FeatureTreeNode.newChildInstanceWithValue("blue", String.valueOf(rgb[2]), color);
                } else {
                    color.addAttribute("errorID", "outlineserr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "outlineserr1", "In Outputlines dictionary value for key \"C\" must be an array of three numbers.");
                }
            }
            FeatureTreeNode.newChildInstanceWithValue("italic", String.valueOf(item.isItalic()), itemNode);
            FeatureTreeNode.newChildInstanceWithValue("bold", String.valueOf(item.isBold()), itemNode);
            for (PDOutlineItem child : item.children()) {
                if (items.contains(child)) continue;
                PBOutlinesFeaturesObject.createItem(child, itemNode, collection, items);
            }
        }
    }
}

