/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBImageXObjectFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBImageXObjectFeaturesObject.class);
    private static final String ID = "id";
    private PDImageXObject imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBImageXObjectFeaturesObject(PDImageXObject imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.IMAGE_XOBJECT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.imageXObject != null) {
            FeatureTreeNode mask;
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("image");
            root.addAttribute(ID, this.id);
            this.parseParents(root);
            FeatureTreeNode.newChildInstanceWithValue("width", String.valueOf(this.imageXObject.getWidth()), root);
            FeatureTreeNode.newChildInstanceWithValue("height", String.valueOf(this.imageXObject.getHeight()), root);
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shading = FeatureTreeNode.newChildInstance("colorSpace", root);
                shading.addAttribute(ID, this.colorSpaceChild);
            }
            FeatureTreeNode.newChildInstanceWithValue("bitsPerComponent", String.valueOf(this.imageXObject.getBitsPerComponent()), root);
            FeatureTreeNode.newChildInstanceWithValue("imageMask", String.valueOf(this.imageXObject.isStencil()), root);
            if (this.maskChild != null) {
                mask = FeatureTreeNode.newChildInstance("mask", root);
                mask.addAttribute(ID, this.maskChild);
            }
            FeatureTreeNode.newChildInstanceWithValue("interpolate", String.valueOf(this.imageXObject.getInterpolate()), root);
            PBCreateNodeHelper.parseIDSet(this.alternatesChild, "alternate", "alternates", root);
            if (this.sMaskChild != null) {
                mask = FeatureTreeNode.newChildInstance("sMask", root);
                mask.addAttribute(ID, this.sMaskChild);
            }
            if (this.imageXObject.getCOSStream().getItem(COSName.STRUCT_PARENT) != null) {
                FeatureTreeNode.newChildInstanceWithValue("structParent", String.valueOf(this.imageXObject.getStructParent()), root);
            }
            try {
                if (this.imageXObject.getStream().getFilters() != null && !this.imageXObject.getStream().getFilters().isEmpty()) {
                    FeatureTreeNode filters = FeatureTreeNode.newChildInstance("filters", root);
                    for (COSName name : this.imageXObject.getStream().getFilters()) {
                        PBCreateNodeHelper.addNotEmptyNode("filter", name.getName(), filters);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
            }
            PBCreateNodeHelper.parseMetadata(this.imageXObject.getMetadata(), "metadata", root, collection);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.IMAGE_XOBJECT, root);
            return root;
        }
        return null;
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }
}

