/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBColorSpaceFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private static final Logger LOGGER = Logger.getLogger(PBColorSpaceFeaturesObject.class);
    private PDColorSpace colorSpace;
    private String id;
    private String iccProfileChild;
    private String colorSpaceChild;
    private Set<String> pageParents;
    private Set<String> colorSpaceParents;
    private Set<String> patternParents;
    private Set<String> shadingParents;
    private Set<String> xobjectParents;
    private Set<String> fontParents;

    public PBColorSpaceFeaturesObject(PDColorSpace colorSpace, String id, String iccProfileChild, String colorSpaceChild, Set<String> pageParents, Set<String> colorSpaceParents, Set<String> patternParents, Set<String> shadingParents, Set<String> xobjectParents, Set<String> fontParents) {
        this.colorSpace = colorSpace;
        this.id = id;
        this.iccProfileChild = iccProfileChild;
        this.colorSpaceChild = colorSpaceChild;
        this.pageParents = pageParents;
        this.colorSpaceParents = colorSpaceParents;
        this.patternParents = patternParents;
        this.shadingParents = shadingParents;
        this.xobjectParents = xobjectParents;
        this.fontParents = fontParents;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.COLORSPACE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.colorSpace != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("colorSpace");
            root.addAttribute(ID, this.id);
            root.addAttribute("family", this.colorSpace.getName());
            this.parseParents(root);
            if (this.colorSpace instanceof PDCIEDictionaryBasedColorSpace) {
                this.parseCIEDictionaryBased(root);
            } else if (this.colorSpace instanceof PDICCBased) {
                PDICCBased icc = (PDICCBased)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.newChildInstance("alternate", root);
                    alt.addAttribute(ID, this.colorSpaceChild);
                }
                FeatureTreeNode.newChildInstanceWithValue("components", String.valueOf(icc.getNumberOfComponents()), root);
                if (this.iccProfileChild != null) {
                    FeatureTreeNode prof = FeatureTreeNode.newChildInstance("iccProfile", root);
                    prof.addAttribute(ID, this.iccProfileChild);
                }
            } else if (this.colorSpace instanceof PDIndexed) {
                this.parseIndexed(root, collection);
            } else if (this.colorSpace instanceof PDSeparation) {
                PDSeparation sep = (PDSeparation)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.newChildInstance("alternate", root);
                    alt.addAttribute(ID, this.colorSpaceChild);
                }
                PBCreateNodeHelper.addNotEmptyNode("colorantName", sep.getColorantName(), root);
            } else if (this.colorSpace instanceof PDDeviceN) {
                PDDeviceN devN = (PDDeviceN)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.newChildInstance("alternate", root);
                    alt.addAttribute(ID, this.colorSpaceChild);
                }
                if (devN.getColorantNames() != null) {
                    this.parseStringList(devN.getColorantNames(), FeatureTreeNode.newChildInstance("colorantNames", root));
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.COLORSPACE, root);
            return root;
        }
        return null;
    }

    private void parseIndexed(FeatureTreeNode root, FeaturesCollection collection) throws FeaturesTreeNodeException {
        PDIndexed index = (PDIndexed)this.colorSpace;
        if (this.colorSpaceChild != null) {
            FeatureTreeNode alt = FeatureTreeNode.newChildInstance("base", root);
            alt.addAttribute(ID, this.colorSpaceChild);
        }
        if (index.getCOSObject() instanceof COSArray && ((COSArray)index.getCOSObject()).size() > 2 && ((COSArray)index.getCOSObject()).getObject(2) instanceof COSNumber) {
            FeatureTreeNode.newChildInstanceWithValue("hival", String.valueOf(((COSNumber)((COSArray)index.getCOSObject()).getObject(2)).intValue()), root);
        } else {
            root.addAttribute("errorID", "clrsperr1");
            ErrorsHelper.addErrorIntoCollection(collection, "clrsperr1", "Error while getting colorSpace.");
        }
        if (index.getCOSObject() instanceof COSArray && ((COSArray)index.getCOSObject()).size() > 3) {
            byte[] lookupData;
            COSBase lookupTable = ((COSArray)index.getCOSObject()).getObject(3);
            if (lookupTable instanceof COSString) {
                lookupData = ((COSString)lookupTable).getBytes();
            } else if (lookupTable instanceof COSStream) {
                try {
                    lookupData = new PDStream((COSStream)lookupTable).getByteArray();
                }
                catch (IOException e) {
                    LOGGER.info((Object)e);
                    lookupData = new byte[]{};
                    this.addError(root, collection);
                }
            } else {
                if (lookupTable != null) {
                    this.addError(root, collection);
                }
                lookupData = new byte[]{};
            }
            try (Formatter formatter = new Formatter();){
                for (byte b : lookupData) {
                    formatter.format("%02X", b);
                }
                FeatureTreeNode.newChildInstanceWithValue("lookup", formatter.toString(), root);
            }
        } else {
            this.addError(root, collection);
        }
    }

    private void addError(FeatureTreeNode root, FeaturesCollection collection) {
        root.addAttribute("errorID", "clrsperr1");
        ErrorsHelper.addErrorIntoCollection(collection, "clrsperr1", "Error while getting colorSpace.");
    }

    private void parseCIEDictionaryBased(FeatureTreeNode root) throws FeaturesTreeNodeException {
        PDCIEDictionaryBasedColorSpace cie = (PDCIEDictionaryBasedColorSpace)this.colorSpace;
        this.parseTristimulus(cie.getWhitepoint(), FeatureTreeNode.newChildInstance("whitePoint", root));
        this.parseTristimulus(cie.getBlackPoint(), FeatureTreeNode.newChildInstance("blackPoint", root));
        if (cie instanceof PDCalGray) {
            PDCalGray calGray = (PDCalGray)cie;
            FeatureTreeNode.newChildInstanceWithValue("gamma", String.valueOf(calGray.getGamma()), root);
        } else if (cie instanceof PDCalRGB) {
            PDCalRGB calRGB = (PDCalRGB)cie;
            FeatureTreeNode gamma = FeatureTreeNode.newChildInstance("gamma", root);
            PDGamma pdGamma = calRGB.getGamma();
            FeatureTreeNode.newChildInstanceWithValue("red", String.valueOf(pdGamma.getR()), gamma);
            FeatureTreeNode.newChildInstanceWithValue("green", String.valueOf(pdGamma.getG()), gamma);
            FeatureTreeNode.newChildInstanceWithValue("blue", String.valueOf(pdGamma.getB()), gamma);
            this.parseFloatArray(calRGB.getMatrix(), FeatureTreeNode.newChildInstance("matrix", root));
        } else if (cie instanceof PDLab) {
            PDLab lab = (PDLab)cie;
            FeatureTreeNode range = FeatureTreeNode.newChildInstance("range", root);
            range.addAttribute("aMin", String.valueOf(lab.getARange().getMin()));
            range.addAttribute("aMax", String.valueOf(lab.getARange().getMax()));
            range.addAttribute("bMin", String.valueOf(lab.getBRange().getMin()));
            range.addAttribute("bMax", String.valueOf(lab.getBRange().getMax()));
        }
    }

    private void parseFloatArray(float[] array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.length; ++i) {
            FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
            element.addAttribute("number", String.valueOf(i));
            element.addAttribute("value", String.valueOf(array[i]));
        }
    }

    private void parseStringList(List<String> array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.size(); ++i) {
            FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
            element.addAttribute("number", String.valueOf(i));
            element.addAttribute("value", String.valueOf(array.get(i)));
        }
    }

    private void parseTristimulus(PDTristimulus tris, FeatureTreeNode curNode) {
        curNode.addAttribute("x", String.valueOf(tris.getX()));
        curNode.addAttribute("y", String.valueOf(tris.getY()));
        curNode.addAttribute("z", String.valueOf(tris.getZ()));
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParents != null && !this.pageParents.isEmpty() || this.colorSpaceParents != null && !this.colorSpaceParents.isEmpty() || this.patternParents != null && !this.patternParents.isEmpty() || this.xobjectParents != null && !this.xobjectParents.isEmpty() || this.shadingParents != null && !this.shadingParents.isEmpty() || this.fontParents != null && !this.fontParents.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParents, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceParents, "colorSpace", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParents, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.shadingParents, "shading", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParents, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParents, "font", null, parents);
        }
    }
}

