/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDTextState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.content.PreflightStreamEngine;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.GlyphException;

public class PreflightContentStream
extends PreflightStreamEngine {
    public PreflightContentStream(PreflightContext _context, PDPage _page) {
        super(_context, _page);
    }

    public void validatePageContentStream() throws ValidationException {
        try {
            PDStream pstream = this.processeedPage.getStream();
            if (pstream != null) {
                this.processPage(this.processeedPage);
            }
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the Page ContentStream : " + e.getMessage(), e);
        }
    }

    public void validateXObjContentStream(PDFormXObject form) throws ValidationException {
        try {
            if (this.processeedPage == null) {
                this.processChildStream((PDContentStream)form, new PDPage());
            } else {
                this.processChildStream((PDContentStream)form, this.processeedPage);
            }
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the XObject ContentStream : " + e.getMessage(), e);
        }
    }

    public void validatePatternContentStream(PDTilingPattern pattern) throws ValidationException {
        try {
            this.processChildStream((PDContentStream)pattern, this.processeedPage);
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the Pattern ContentStream : " + e.getMessage(), e);
        }
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        super.processOperator(operator, operands);
        if ("BI".equals(operator.getName())) {
            this.validateImageFilter(operator);
            this.validateImageColorSpace(operator);
        }
        this.checkShowTextOperators(operator, operands);
        this.checkColorOperators(operator.getName());
        this.validateRenderingIntent(operator, operands);
        this.checkSetColorSpaceOperators(operator, operands);
        this.validateNumberOfGraphicStates(operator);
    }

    protected void unsupportedOperator(Operator operator, List<COSBase> arguments) {
        this.registerError("The operator \"" + operator.getName() + "\" isn't supported.", "1.2.10");
    }

    protected void checkShowTextOperators(Operator operator, List<?> arguments) throws IOException {
        String op = operator.getName();
        if ("Tj".equals(op) || "'".equals(op) || "\"".equals(op)) {
            this.validateStringDefinition(operator, arguments);
        }
        if ("TJ".equals(op)) {
            this.validateStringArray(operator, arguments);
        }
    }

    private void validateStringDefinition(Operator operator, List<?> arguments) throws IOException {
        if ("\"".equals(operator.getName())) {
            if (arguments.size() != 3) {
                this.registerError("Invalid argument for the operator : " + operator.getName(), "1.2.11");
                return;
            }
            Object arg0 = arguments.get(0);
            Object arg1 = arguments.get(1);
            Object arg2 = arguments.get(2);
            if (!(arg0 instanceof COSInteger) && !(arg0 instanceof COSFloat) || !(arg1 instanceof COSInteger) && !(arg1 instanceof COSFloat)) {
                this.registerError("Invalid argument for the operator : " + operator.getName(), "1.2.11");
                return;
            }
            if (arg2 instanceof COSString) {
                this.validateText(((COSString)arg2).getBytes());
            } else {
                this.registerError("Invalid argument for the operator : " + operator.getName(), "1.2.11");
            }
        } else {
            Object objStr = arguments.get(0);
            if (objStr instanceof COSString) {
                this.validateText(((COSString)objStr).getBytes());
            } else if (!(objStr instanceof COSInteger)) {
                this.registerError("Invalid argument for the operator : " + operator.getName(), "1.2.11");
            }
        }
    }

    private void validateStringArray(Operator operator, List<?> arguments) throws IOException {
        for (Object object : arguments) {
            if (object instanceof COSArray) {
                this.validateStringArray(operator, ((COSArray)object).toList());
                continue;
            }
            if (object instanceof COSString) {
                this.validateText(((COSString)object).getBytes());
                continue;
            }
            if (object instanceof COSInteger || object instanceof COSFloat) continue;
            this.registerError("Invalid argument for the operator : " + operator.getName(), "1.2.11");
            return;
        }
    }

    public void validateText(byte[] string) throws IOException {
        PDTextState textState = this.getGraphicsState().getTextState();
        RenderingMode renderingMode = textState.getRenderingMode();
        PDFont font = textState.getFont();
        if (font == null) {
            this.registerError("Text operator can't be process without Font", "3.3.2");
            return;
        }
        FontContainer fontContainer = this.context.getFontContainer((COSBase)font.getCOSObject());
        if (!(renderingMode != RenderingMode.NEITHER || fontContainer != null && fontContainer.isEmbeddedFont())) {
            return;
        }
        if (fontContainer == null) {
            this.registerError(font.getName() + " is unknown wasn't found by the FontHelperValidator", "3.3.2");
            return;
        }
        if (!fontContainer.isValid() && !fontContainer.errorsAleadyMerged()) {
            this.context.addValidationErrors(fontContainer.getAllErrors());
            fontContainer.setErrorsAlreadyMerged(true);
            return;
        }
        if (!fontContainer.isValid() && fontContainer.errorsAleadyMerged()) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(string);
        while (((InputStream)in).available() > 0) {
            try {
                int code = font.readCode((InputStream)in);
                fontContainer.checkGlyphWidth(code);
            }
            catch (IOException e) {
                this.registerError("Encoding can't interpret the character code", "3.1.12", e);
                return;
            }
            catch (GlyphException e) {
                if (renderingMode == RenderingMode.NEITHER) continue;
                this.registerError(e.getMessage(), e.getErrorCode(), e);
                return;
            }
        }
    }
}

