/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.FontBoxFont;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.external.PBoxFontProgram;
import org.verapdf.model.impl.pb.external.PBoxTrueTypeFontProgram;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;

public abstract class PBoxPDFont
extends PBoxPDResources
implements org.verapdf.model.pdlayer.PDFont {
    public static final String FONT_FILE = "fontFile";

    protected PBoxPDFont(PDFontLike font, String type) {
        super(font, type);
    }

    public String getType() {
        String subtype = null;
        if (this.pdFontLike instanceof PDFont) {
            subtype = ((PDFont)this.pdFontLike).getType();
        } else if (this.pdFontLike instanceof PDCIDFont) {
            subtype = ((PDCIDFont)this.pdFontLike).getCOSObject().getNameAsString(COSName.TYPE);
        }
        return subtype;
    }

    public String getSubtype() {
        String subtype = null;
        if (this.pdFontLike instanceof PDFont) {
            subtype = ((PDFont)this.pdFontLike).getSubType();
        } else if (this.pdFontLike instanceof PDCIDFont) {
            subtype = ((PDCIDFont)this.pdFontLike).getCOSObject().getNameAsString(COSName.SUBTYPE);
        }
        return subtype;
    }

    public String getBaseFont() {
        return this.pdFontLike.getName();
    }

    public Boolean getisSymbolic() {
        PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
        return fontDescriptor.isSymbolic();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (FONT_FILE.equals(link)) {
            return this.getFontFile();
        }
        return super.getLinkedObjects(link);
    }

    private List<PBoxFontProgram> getFontFile() {
        ArrayList<PBoxFontProgram> list = new ArrayList<PBoxFontProgram>(1);
        if (!this.getSubtype().equals("Type3") && this.pdFontLike.isEmbedded()) {
            if (this.getSubtype().equals("TrueType")) {
                PBoxTrueTypeFontProgram trueTypeFontProgram = new PBoxTrueTypeFontProgram((FontBoxFont)((PDTrueTypeFont)this.pdFontLike).getTrueTypeFont(), this.getisSymbolic());
                list.add(trueTypeFontProgram);
                return list;
            }
            PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
            PDStream fontFile = this.getSubtype().equals("Type1") ? (this.pdFontLike instanceof PDType1CFont ? fontDescriptor.getFontFile3() : fontDescriptor.getFontFile()) : fontDescriptor.getFontFile3();
            if (fontFile != null) {
                list.add(new PBoxFontProgram(fontFile));
            }
        }
        return list;
    }
}

