/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.operator.textshow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.factory.font.FontFactory;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.operator.base.PBOperator;
import org.verapdf.model.impl.pb.operator.textshow.PBCIDGlyph;
import org.verapdf.model.impl.pb.operator.textshow.PBGlyph;
import org.verapdf.model.operator.OpTextShow;
import org.verapdf.model.pdlayer.PDFont;
import org.verapdf.model.tools.FontHelper;

public abstract class PBOpTextShow
extends PBOperator
implements OpTextShow {
    private static final Logger LOGGER = Logger.getLogger(PBOpTextShow.class);
    public static final String FONT = "font";
    public static final String USED_GLYPHS = "usedGlyphs";
    public static final String FILL_COLOR_SPACE = "fillCS";
    public static final String STROKE_COLOR_SPACE = "strokeCS";
    protected final GraphicState state;

    protected PBOpTextShow(List<COSBase> arguments, GraphicState state, String opType) {
        super(arguments, opType);
        this.state = state;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "font": {
                return this.getFont();
            }
            case "usedGlyphs": {
                return this.getUsedGlyphs();
            }
            case "fillCS": {
                return this.getFillColorSpace();
            }
            case "strokeCS": {
                return this.getStrokeColorSpace();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFont> getFont() {
        ArrayList<PDFont> result = new ArrayList<PDFont>(1);
        PDFont font = FontFactory.parseFont(this.state.getFont());
        if (font != null) {
            result.add(font);
        }
        return result;
    }

    private List<PBGlyph> getUsedGlyphs() {
        ArrayList<PBGlyph> res = new ArrayList<PBGlyph>();
        org.apache.pdfbox.pdmodel.font.PDFont font = this.state.getFont();
        FontContainer fontContainer = FontHelper.getFontContainer(font);
        List<byte[]> strings = this.getStrings(this.arguments);
        for (byte[] string : strings) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(string);
                Throwable throwable = null;
                try {
                    while (((InputStream)inputStream).available() > 0) {
                        PBGlyph glyph;
                        int code = font.readCode((InputStream)inputStream);
                        Boolean glyphPresent = fontContainer.hasGlyph(code);
                        Boolean widthsConsistent = this.checkWidths(code);
                        if (font.getSubType().equals("Type0")) {
                            int CID = ((PDType0Font)font).codeToCID(code);
                            glyph = new PBCIDGlyph(glyphPresent, widthsConsistent, font.getName(), code, CID);
                        } else {
                            glyph = new PBGlyph(glyphPresent, widthsConsistent, font.getName(), code);
                        }
                        res.add(glyph);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error processing text show operator's string argument : " + new String(string)));
                LOGGER.info((Object)e);
            }
        }
        return res;
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getFillColorSpace() {
        if (this.state.getRenderingMode().isFill()) {
            return this.getColorSpace(this.state.getFillColorSpace());
        }
        return new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getStrokeColorSpace() {
        if (this.state.getRenderingMode().isStroke()) {
            return this.getColorSpace(this.state.getStrokeColorSpace());
        }
        return new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace(PDColorSpace fillColorSpace) {
        ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
        org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(fillColorSpace, this.state.getPattern());
        if (colorSpace != null) {
            colorSpaces.add(colorSpace);
        }
        return colorSpaces;
    }

    private Boolean checkWidths(int glyphCode) throws IOException {
        org.apache.pdfbox.pdmodel.font.PDFont font = this.state.getFont();
        float expectedWidth = font.getWidth(glyphCode);
        float foundWidth = font.getWidthFromFont(glyphCode);
        return Math.abs(foundWidth - expectedWidth) > 1.0f ? Boolean.FALSE : Boolean.TRUE;
    }

    private List<byte[]> getStrings(List<COSBase> arguments) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        if (!arguments.isEmpty()) {
            COSBase arg = arguments.get(0);
            if (arg instanceof COSArray) {
                this.addArrayElements(res, (COSArray)arg);
            } else if (arg instanceof COSString) {
                res.add(((COSString)arg).getBytes());
            }
        }
        return res;
    }

    private void addArrayElements(List<byte[]> res, COSArray arg) {
        for (COSBase element : arg) {
            if (!(element instanceof COSString)) continue;
            res.add(((COSString)element).getBytes());
        }
    }
}

