/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosNull;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.impl.pb.cos.PBCosNull;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.tools.IDGenerator;

public class PBCosIndirect
extends PBCosObject
implements CosIndirect {
    public static final String DIRECT_OBJECT = "directObject";
    public static final String COS_INDIRECT_TYPE = "CosIndirect";
    private final boolean isSpacingPDFACompliant;
    private final String id;

    public PBCosIndirect(COSObject indirectObject) {
        super((COSBase)indirectObject, COS_INDIRECT_TYPE);
        this.isSpacingPDFACompliant = PBCosIndirect.getspacingCompliesPDFA((COSBase)indirectObject);
        this.id = IDGenerator.generateID((COSBase)indirectObject);
    }

    public String getID() {
        return this.id;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (DIRECT_OBJECT.equals(link)) {
            return this.parseDirectObject();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosObject> parseDirectObject() {
        ArrayList<CosNull> list = new ArrayList<CosNull>();
        COSBase base = ((COSObject)this.baseObject).getObject();
        list.add((CosNull)(base != null ? PBCosIndirect.getFromValue(base) : PBCosNull.getInstance()));
        return Collections.unmodifiableList(list);
    }

    public Boolean getspacingCompliesPDFA() {
        return this.isSpacingPDFACompliant;
    }

    private static boolean getspacingCompliesPDFA(COSBase base) {
        return ((COSObject)base).isEndOfObjectComplyPDFA() != false && ((COSObject)base).isHeaderFormatComplyPDFA() != false && ((COSObject)base).isHeaderOfObjectComplyPDFA() != false;
    }
}

