/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.model.coslayer.CosXRef;
import org.verapdf.model.impl.pb.cos.PBCosFileSpecification;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.cos.PBCosTrailer;
import org.verapdf.model.impl.pb.cos.PBCosXRef;
import org.verapdf.model.impl.pb.pd.PBoxPDDocument;
import org.verapdf.model.tools.XMPChecker;

public class PBCosDocument
extends PBCosObject
implements CosDocument {
    private static final Logger LOGGER = Logger.getLogger(PBCosDocument.class);
    public static final String COS_DOCUMENT_TYPE = "CosDocument";
    public static final String TRAILER = "trailer";
    public static final String XREF = "xref";
    public static final String INDIRECT_OBJECTS = "indirectObjects";
    public static final String DOCUMENT = "document";
    public static final String EMBEDDED_FILES = "EmbeddedFiles";
    public static final String ID = "ID";
    private PDDocument pdDocument;
    private final long sizeOfDocument;
    private final long indirectObjectCount;
    private final float version;
    private final boolean isBinaryHeaderPDFACompliant;
    private final boolean isPDFHeaderPDFACompliant;
    private final boolean isOptionalContentPresent;
    private final boolean isLinearised;
    private final Boolean isEofPDFACompliant;
    private final Boolean doesInfoMatchXMP;
    private final String firstPageID;
    private final String lastID;

    public PBCosDocument(PDDocument pdDocument, long length) {
        this(pdDocument.getDocument(), length);
        this.pdDocument = pdDocument;
    }

    public PBCosDocument(COSDocument cosDocument) {
        this(cosDocument, -1L);
    }

    public PBCosDocument(COSDocument cosDocument, long length) {
        super((COSBase)cosDocument, COS_DOCUMENT_TYPE);
        this.sizeOfDocument = length;
        this.indirectObjectCount = cosDocument.getObjects().size();
        this.version = cosDocument.getVersion();
        this.isBinaryHeaderPDFACompliant = cosDocument.getNonValidCommentContent() == false && cosDocument.getNonValidCommentLength() == false && cosDocument.getNonValidCommentStart() == false;
        this.isPDFHeaderPDFACompliant = cosDocument.getNonValidHeader() == false;
        this.isOptionalContentPresent = PBCosDocument.parseOptionalContentPresent(cosDocument);
        this.isEofPDFACompliant = cosDocument.getEofComplyPDFA();
        this.lastID = PBCosDocument.getTrailerID((COSArray)cosDocument.getLastTrailer().getItem(ID));
        this.firstPageID = PBCosDocument.getTrailerID((COSArray)cosDocument.getFirstPageTrailer().getDictionaryObject(ID));
        this.isLinearised = cosDocument.getTrailer() != cosDocument.getLastTrailer() && cosDocument.isLinearized() != false;
        this.doesInfoMatchXMP = XMPChecker.doesInfoMatchXMP(cosDocument);
    }

    public Long getnrIndirects() {
        return this.indirectObjectCount;
    }

    public Double getversion() {
        return this.version;
    }

    public Long getsize() {
        return this.sizeOfDocument;
    }

    public Boolean getbinaryHeaderComplyPDFA() {
        return this.isBinaryHeaderPDFACompliant;
    }

    public Boolean getpdfHeaderCompliesPDFA() {
        return this.isPDFHeaderPDFACompliant;
    }

    public Boolean getisOptionalContentPresent() {
        return this.isOptionalContentPresent;
    }

    public Boolean geteofCompliesPDFA() {
        return this.isEofPDFACompliant;
    }

    public String getfirstPageID() {
        return this.firstPageID;
    }

    public String getlastID() {
        return this.lastID;
    }

    private static String getTrailerID(COSArray ids) {
        if (ids != null) {
            StringBuilder builder = new StringBuilder();
            for (COSBase id : ids) {
                for (byte aByte : ((COSString)id).getBytes()) {
                    builder.append((char)(aByte & 0xFF));
                }
                builder.append(' ');
            }
            return builder.toString().substring(0, builder.length() - 1);
        }
        return null;
    }

    public Boolean getisLinearized() {
        return this.isLinearised;
    }

    public Boolean getdoesInfoMatchXMP() {
        return this.doesInfoMatchXMP;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "trailer": {
                return this.getTrailer();
            }
            case "indirectObjects": {
                return this.getIndirectObjects();
            }
            case "document": {
                return this.getDocument();
            }
            case "xref": {
                return this.getXRefs();
            }
            case "EmbeddedFiles": {
                return this.getEmbeddedFiles();
            }
        }
        return super.getLinkedObjects(link);
    }

    private static boolean parseOptionalContentPresent(COSDocument cosDocument) {
        try {
            COSDictionary root = (COSDictionary)cosDocument.getCatalog().getObject();
            return root.getItem(COSName.OCPROPERTIES) != null;
        }
        catch (IOException e) {
            LOGGER.debug((Object)"No document catalog found", (Throwable)e);
            return false;
        }
    }

    private List<org.verapdf.model.baselayer.Object> getEmbeddedFiles() {
        ArrayList<org.verapdf.model.baselayer.Object> files = new ArrayList<org.verapdf.model.baselayer.Object>();
        try {
            COSDictionary buffer = (COSDictionary)this.pdDocument.getDocument().getCatalog().getObject();
            buffer = (COSDictionary)buffer.getDictionaryObject(COSName.NAMES);
            if (buffer != null) {
                buffer = (COSDictionary)buffer.getDictionaryObject(COSName.EMBEDDED_FILES);
            }
            PBCosDocument.getNamesEmbeddedFiles(files, buffer);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Something wrong with getting embedded files - return empty list. " + e.getMessage()), (Throwable)e);
        }
        return files;
    }

    private static void getNamesEmbeddedFiles(List<org.verapdf.model.baselayer.Object> files, COSDictionary buffer) throws IOException {
        PDEmbeddedFilesNameTreeNode root = null;
        if (buffer != null) {
            root = new PDEmbeddedFilesNameTreeNode(buffer);
        }
        if (root != null) {
            Set entries = root.getNames().entrySet();
            for (Map.Entry entry : entries) {
                files.add((org.verapdf.model.baselayer.Object)new PBCosFileSpecification(((PDComplexFileSpecification)entry.getValue()).getCOSObject()));
            }
        }
    }

    private List<CosTrailer> getTrailer() {
        COSDocument cosDocument = (COSDocument)this.baseObject;
        ArrayList<PBCosTrailer> list = new ArrayList<PBCosTrailer>(1);
        list.add(new PBCosTrailer(cosDocument.getTrailer()));
        return Collections.unmodifiableList(list);
    }

    private List<CosIndirect> getIndirectObjects() {
        List objects = ((COSDocument)this.baseObject).getObjects();
        ArrayList<PBCosIndirect> list = new ArrayList<PBCosIndirect>(objects.size());
        for (COSObject object : objects) {
            list.add(new PBCosIndirect(object));
        }
        return Collections.unmodifiableList(list);
    }

    private List<org.verapdf.model.pdlayer.PDDocument> getDocument() {
        ArrayList<org.verapdf.model.pdlayer.PDDocument> document = new ArrayList<org.verapdf.model.pdlayer.PDDocument>(1);
        if (this.pdDocument != null) {
            document.add(new PBoxPDDocument(this.pdDocument));
        }
        return document;
    }

    private List<CosXRef> getXRefs() {
        COSDocument cosDocument = (COSDocument)this.baseObject;
        ArrayList<PBCosXRef> list = new ArrayList<PBCosXRef>(1);
        list.add(new PBCosXRef(cosDocument.isXRefSpacingsCompliesPDFA(), cosDocument.isXRefEOLCompliesPDFA()));
        return Collections.unmodifiableList(list);
    }
}

