/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;

public final class ValidationProfileSignatureChecker {
    private static final String HASH_NAME = "hash";
    private static final String HASH_OPEN_TAG = "<hash>";
    private static final String HASH_CLOSE_TAG = "</hash>";
    private static final String HASH_EMPTY_TAG = "<hash/>";
    private static final String UTF8 = "utf-8";
    private static final byte[] KEY_ARRAY = new byte[]{-48, -78, -48, -75, -47, -128, -48, -80, -48, -97, -48, -108, -48, -92};
    private File profile;
    private int startOfHash = -1;
    private int endOfHash = -1;
    private String contentWithoutHash;
    private String currentHashAsString;
    private String realHashAsString;
    private byte[] realHashAsBytes;

    private ValidationProfileSignatureChecker(File file) {
        this.profile = file;
    }

    private void parseProfile() throws IOException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try (FileInputStream profileStream = new FileInputStream(this.profile);){
            XMLStreamReader streamReader = factory.createXMLStreamReader(profileStream);
            if (!UTF8.equalsIgnoreCase(streamReader.getEncoding())) {
                streamReader.close();
                throw new UnsupportedEncodingException("Only UTF-8 encoded profiles are parsable, please check : " + this.profile.getCanonicalPath());
            }
            while (streamReader.hasNext()) {
                Location location;
                streamReader.next();
                if (streamReader.isStartElement() && HASH_NAME.equals(streamReader.getLocalName())) {
                    location = streamReader.getLocation();
                    this.startOfHash = location.getCharacterOffset();
                    this.currentHashAsString = streamReader.getElementText().trim();
                }
                if (!streamReader.isEndElement() || !HASH_NAME.equals(streamReader.getLocalName())) continue;
                location = streamReader.getLocation();
                this.endOfHash = location.getCharacterOffset();
                if (this.endOfHash != this.startOfHash) {
                    this.startOfHash -= HASH_OPEN_TAG.length();
                    continue;
                }
                this.startOfHash -= HASH_EMPTY_TAG.length();
            }
        }
    }

    private byte[] getBytesForHash() throws IOException, MissedHashTagException {
        if (this.startOfHash < 0 || this.endOfHash < 0 || this.startOfHash > this.endOfHash) {
            throw new MissedHashTagException("Can not find well formed hash element in the validation profile at path: " + this.profile.getCanonicalPath());
        }
        byte[] bytesOfFile = Files.readAllBytes(this.profile.toPath());
        String fileString = new String(bytesOfFile, UTF8);
        this.contentWithoutHash = fileString.substring(0, this.startOfHash) + fileString.substring(this.endOfHash);
        return ValidationProfileSignatureChecker.concatenateByteArrays(this.contentWithoutHash.getBytes(UTF8), KEY_ARRAY);
    }

    private static byte[] concatenateByteArrays(byte[] array1, byte[] array2) {
        byte[] res = Arrays.copyOf(array1, array1.length + array2.length);
        for (int i = 0; i < array2.length; ++i) {
            res[i + array1.length] = array2[i];
        }
        return res;
    }

    private static String byteArrayToHex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    private static byte[] getSHA1(byte[] source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(source);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Required JRE SHA-1 algorithm not found", e);
        }
    }

    public String getHashAsString() {
        return this.realHashAsString;
    }

    public boolean isValidSignature() {
        return this.realHashAsString.equals(this.currentHashAsString);
    }

    public void signFile() throws IOException, XMLStreamException {
        String resultingContent = this.contentWithoutHash.substring(0, this.startOfHash) + HASH_OPEN_TAG + this.realHashAsString + HASH_CLOSE_TAG + this.contentWithoutHash.substring(this.startOfHash);
        try (FileOutputStream out = new FileOutputStream(this.profile);){
            out.write(resultingContent.getBytes(UTF8));
        }
        this.parseProfile();
    }

    public static ValidationProfileSignatureChecker newInstance(File profile) throws MissedHashTagException, XMLStreamException, IOException {
        if (profile == null) {
            throw new NullPointerException("Null pointer to the profile is used for creating signature checker.");
        }
        ValidationProfileSignatureChecker checker = new ValidationProfileSignatureChecker(profile);
        checker.parseProfile();
        byte[] source = checker.getBytesForHash();
        checker.realHashAsBytes = ValidationProfileSignatureChecker.getSHA1(source);
        checker.realHashAsString = ValidationProfileSignatureChecker.byteArrayToHex(checker.realHashAsBytes);
        return checker;
    }
}

