/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.pd.PBoxPDAction;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;

public class PBoxPDAnnot
extends PBoxPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final int MAX_COUNT_OF_ACTIONS = 10;
    public static final String NAMED_KEYWORD = "Named";

    public PBoxPDAnnot(PDAnnotation simplePDObject) {
        super((COSObjectable)simplePDObject, ANNOTATION_TYPE);
    }

    public String getSubtype() {
        return ((PDAnnotation)this.simplePDObject).getSubtype();
    }

    public String getAP() {
        COSBase ap = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AP);
        return ap != null ? ap.toString() : null;
    }

    public Long getF() {
        return ((PDAnnotation)this.simplePDObject).getAnnotationFlags();
    }

    public Double getCA() {
        COSBase ca = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.CA);
        return ca instanceof COSNumber ? Double.valueOf(((COSNumber)ca).doubleValue()) : null;
    }

    public String getN_type() {
        PDAppearanceDictionary appearanceDictionary = ((PDAnnotation)this.simplePDObject).getAppearance();
        if (appearanceDictionary != null) {
            PDAppearanceEntry normalAppearance = appearanceDictionary.getNormalAppearance();
            if (normalAppearance == null) {
                return null;
            }
            if (normalAppearance.isSubDictionary()) {
                return DICT;
            }
            return STREAM;
        }
        return null;
    }

    public String getFT() {
        COSBase ft = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.FT);
        if (ft != null && ft instanceof COSName) {
            return ((COSName)ft).getName();
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "IC": {
                return this.getIC();
            }
            case "C": {
                return this.getC();
            }
            case "appearance": {
                return this.getAppearance();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDAction> getAdditionalActions() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(10);
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AA);
        if (actionDictionary instanceof COSDictionary) {
            PDAnnotationAdditionalActions additionalActions = new PDAnnotationAdditionalActions((COSDictionary)actionDictionary);
            PDAction buffer = additionalActions.getBl();
            this.addAction(actions, buffer);
            buffer = additionalActions.getD();
            this.addAction(actions, buffer);
            buffer = additionalActions.getE();
            this.addAction(actions, buffer);
            buffer = additionalActions.getFo();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPC();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPI();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPO();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPV();
            this.addAction(actions, buffer);
            buffer = additionalActions.getU();
            this.addAction(actions, buffer);
            buffer = additionalActions.getX();
            this.addAction(actions, buffer);
        }
        return actions;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getA() {
        PDAction action;
        org.verapdf.model.pdlayer.PDAction result;
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.A);
        if (actionDictionary instanceof COSDictionary && (result = PBoxPDAction.getAction(action = PDActionFactory.createAction((COSDictionary)((COSDictionary)actionDictionary)))) != null) {
            actions.add(result);
        }
        return actions;
    }

    private List<CosReal> getIC() {
        return this.getRealsFromArray(COSName.IC);
    }

    private List<CosReal> getC() {
        return this.getRealsFromArray(COSName.C);
    }

    private List<CosReal> getRealsFromArray(COSName arrayName) {
        ArrayList<CosReal> color = new ArrayList<CosReal>();
        COSBase colorArray = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(arrayName);
        if (colorArray instanceof COSArray) {
            for (COSBase colorValue : (COSArray)colorArray) {
                if (!(colorValue instanceof COSNumber)) continue;
                color.add(new PBCosReal((COSNumber)colorValue));
            }
        }
        return color;
    }

    private List<PDContentStream> getAppearance() {
        PDAppearanceEntry normalAppearance;
        ArrayList<PDContentStream> appearances = new ArrayList<PDContentStream>(1);
        PDAppearanceDictionary appearanceDictionary = ((PDAnnotation)this.simplePDObject).getAppearance();
        if (appearanceDictionary != null && (normalAppearance = appearanceDictionary.getNormalAppearance()) != null && normalAppearance.isStream()) {
            appearances.add(new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)normalAppearance.getAppearanceStream()));
        }
        return appearances;
    }
}

