/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.PDResources;
import org.verapdf.model.factory.operator.OperatorParser;

public final class OperatorFactory {
    private static final Logger LOGGER = Logger.getLogger(OperatorFactory.class);
    private static final String MSG_UNEXPECTED_OBJECT_TYPE = "Unexpected type of object in tokens: ";
    private static final String GS_CLONE_MALFUNCTION = "GraphicsState clone function threw CloneNotSupportedException.";

    private OperatorFactory() {
    }

    public static List<org.verapdf.model.operator.Operator> operatorsFromTokens(List<Object> pdfBoxTokens, PDResources resources) {
        ArrayList<org.verapdf.model.operator.Operator> result = new ArrayList<org.verapdf.model.operator.Operator>();
        ArrayList<Object> arguments = new ArrayList<COSBase>();
        OperatorParser parser = new OperatorParser();
        for (Object pdfBoxToken : pdfBoxTokens) {
            if (pdfBoxToken instanceof COSBase) {
                arguments.add((COSBase)pdfBoxToken);
                continue;
            }
            if (pdfBoxToken instanceof Operator) {
                try {
                    parser.parseOperator(result, (Operator)pdfBoxToken, resources, arguments);
                    arguments = new ArrayList();
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.debug((Object)("GraphicsState clone issues for pdfBoxToken:" + pdfBoxToken));
                    LOGGER.debug((Object)GS_CLONE_MALFUNCTION, (Throwable)e);
                }
                continue;
            }
            LOGGER.error((Object)(MSG_UNEXPECTED_OBJECT_TYPE + pdfBoxToken.getClass().getName()));
        }
        return result;
    }
}

