/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;

public final class FeatureTreeNode {
    private final String name;
    private Object value;
    private final FeatureTreeNode parent;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<FeatureTreeNode> children;

    private FeatureTreeNode(String name) throws FeaturesTreeNodeException {
        this(name, null);
    }

    private FeatureTreeNode(String name, Object value) throws FeaturesTreeNodeException {
        this(name, value, null);
    }

    private FeatureTreeNode(String name, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        this(name, null, parent);
    }

    private FeatureTreeNode(String name, Object value, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        this.name = name;
        this.value = value;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public static FeatureTreeNode newRootInstance(String name) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name);
    }

    public static FeatureTreeNode newRootInstanceWIthValue(String name, Object value) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name, value);
    }

    public static FeatureTreeNode newChildInstance(String name, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name, parent);
    }

    public static FeatureTreeNode newChildInstanceWithValue(String name, Object value, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name, value, parent);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public FeatureTreeNode getParent() {
        return this.parent;
    }

    public List<FeatureTreeNode> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public void addChild(FeatureTreeNode child) throws FeaturesTreeNodeException {
        if (child != null) {
            if (this.value == null) {
                if (this.children == null) {
                    this.children = new ArrayList<FeatureTreeNode>();
                }
                this.children.add(child);
            } else {
                throw new FeaturesTreeNodeException("You can not add childrens for nodes with defined values. Node name " + this.name + ", value: " + this.value.toString() + ".");
            }
        }
    }

    public void setValue(Object value) throws FeaturesTreeNodeException {
        if (this.children != null) {
            throw new FeaturesTreeNodeException("You can not add value for nodes with childrens. Node name " + this.name + ".");
        }
        this.value = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureTreeNode other = (FeatureTreeNode)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.children == null ? other.children != null : !FeatureTreeNode.isChildrenMatch(this, other)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : (this.value instanceof byte[] && other.value instanceof byte[] ? !Arrays.equals((byte[])this.value, (byte[])other.value) : !this.value.equals(other.value)));
    }

    private static boolean isChildrenMatch(FeatureTreeNode aThis, FeatureTreeNode other) {
        return aThis.children == other.children || !(aThis.children == null ^ other.children == null) && aThis.children.size() == other.children.size() && aThis.children.containsAll(other.children);
    }
}

