/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBICCProfileFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBICCProfileFeaturesObject.class);
    private static final String ID = "id";
    private static final int HEADER_SIZE = 128;
    private static final int FF_FLAG = 255;
    private static final int F_FLAG = 15;
    private static final int REQUIRED_LENGTH = 4;
    private static final int TAGINFO_LENGTH = 12;
    private static final int BITSINBYTE = 8;
    private static final int VERSION_BYTE = 8;
    private static final int SUBVERSION_BYTE = 9;
    private static final int CMMTYPE_BEGIN = 4;
    private static final int CMMTYPE_END = 8;
    private static final int DATACOLORSPACE_BEGIN = 16;
    private static final int DATACOLORSPACE_END = 20;
    private static final int RENDERINGINTENT_BEGIN = 64;
    private static final int RENDERINGINTENT_END = 68;
    private static final int PROFILEID_BEGIN = 84;
    private static final int PROFILEID_END = 100;
    private static final int DEVICEMODEL_BEGIN = 52;
    private static final int DEVICEMODEL_END = 56;
    private static final int DEVICEMANUFACTURER_BEGIN = 48;
    private static final int DEVICEMANUFACTURER_END = 52;
    private static final int CREATOR_BEGIN = 80;
    private static final int CREATOR_END = 84;
    private static final int CREATION_YEAR = 24;
    private static final int CREATION_MONTH = 26;
    private static final int CREATION_DAY = 28;
    private static final int CREATION_HOUR = 30;
    private static final int CREATION_MIN = 32;
    private static final int CREATION_SEC = 34;
    private static final int FIRST_RECORD_STRING_LENGTH_IN_TEXTDESCRIPTIONTYPE_BEGIN = 8;
    private static final int FIRST_RECORD_STRING_LENGTH_IN_TEXTDESCRIPTIONTYPE_END = 12;
    private static final int NUMBER_OF_RECORDS_IN_MULTILOCALIZEDUNICODETYPE_BEGIN = 8;
    private static final int NUMBER_OF_RECORDS_IN_MULTILOCALIZEDUNICODETYPE_END = 12;
    private COSStream profile;
    private String id;
    private Set<String> outInts;
    private Set<String> iccBaseds;

    public PBICCProfileFeaturesObject(COSStream profile, String id, Set<String> outInts, Set<String> iccBaseds) {
        this.profile = profile;
        this.id = id;
        this.outInts = outInts;
        this.iccBaseds = iccBaseds;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.ICCPROFILE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.profile != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("iccProfile");
            if (this.id != null) {
                root.addAttribute(ID, this.id);
            }
            this.addParents(root);
            this.parseProfileHeader(root, collection);
            COSBase cosBase = this.profile.getDictionaryObject(COSName.METADATA);
            if (cosBase instanceof COSStream) {
                PDMetadata meta = new PDMetadata((COSStream)cosBase);
                PBCreateNodeHelper.parseMetadata(meta, "metadata", root, collection);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.ICCPROFILE, root);
            return root;
        }
        return null;
    }

    private void addParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.outInts != null && !this.outInts.isEmpty() || this.iccBaseds != null && !this.iccBaseds.isEmpty()) {
            FeatureTreeNode pageNode;
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            if (this.outInts != null) {
                for (String outInt : this.outInts) {
                    if (outInt == null) continue;
                    pageNode = FeatureTreeNode.newChildInstance("outputIntent", parents);
                    pageNode.addAttribute(ID, outInt);
                }
            }
            if (this.iccBaseds != null) {
                for (String iccBased : this.iccBaseds) {
                    if (iccBased == null) continue;
                    pageNode = FeatureTreeNode.newChildInstance("iccBased", parents);
                    pageNode.addAttribute(ID, iccBased);
                }
            }
        }
    }

    private void parseProfileHeader(FeatureTreeNode root, FeaturesCollection collection) throws FeaturesTreeNodeException {
        try {
            byte[] profileBytes = PBICCProfileFeaturesObject.inputStreamToByteArray(this.profile.getUnfilteredStream());
            if (profileBytes.length < 128) {
                root.addAttribute("errorID", "iccprofileerr3");
                ErrorsHelper.addErrorIntoCollection(collection, "iccprofileerr3", "ICC Profile has less than 128 bytes.");
            } else {
                PBCreateNodeHelper.addNotEmptyNode("version", PBICCProfileFeaturesObject.getVersion(profileBytes), root);
                PBCreateNodeHelper.addNotEmptyNode("cmmType", PBICCProfileFeaturesObject.getString(profileBytes, 4, 8), root);
                PBCreateNodeHelper.addNotEmptyNode("dataColorSpace", PBICCProfileFeaturesObject.getString(profileBytes, 16, 20), root);
                PBCreateNodeHelper.addNotEmptyNode("creator", PBICCProfileFeaturesObject.getString(profileBytes, 80, 84), root);
                PBCreateNodeHelper.createDateNode("creationDate", root, PBICCProfileFeaturesObject.getCreationDate(profileBytes), collection);
                String intent = PBICCProfileFeaturesObject.getIntent(PBICCProfileFeaturesObject.getString(profileBytes, 64, 68));
                PBCreateNodeHelper.addNotEmptyNode("defaultRenderingIntent", intent, root);
                PBCreateNodeHelper.addNotEmptyNode("copyright", PBICCProfileFeaturesObject.getStringTag(profileBytes, "cprt"), root);
                PBCreateNodeHelper.addNotEmptyNode("description", PBICCProfileFeaturesObject.getStringTag(profileBytes, "desc"), root);
                PBCreateNodeHelper.addNotEmptyNode("profileId", PBICCProfileFeaturesObject.getString(profileBytes, 84, 100), root);
                PBCreateNodeHelper.addNotEmptyNode("deviceModel", PBICCProfileFeaturesObject.getString(profileBytes, 52, 56), root);
                PBCreateNodeHelper.addNotEmptyNode("deviceManufacturer", PBICCProfileFeaturesObject.getString(profileBytes, 48, 52), root);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Reading byte array from InputStream error", (Throwable)e);
            root.addAttribute("errorID", "iccprofileerr2");
            ErrorsHelper.addErrorIntoCollection(collection, "iccprofileerr2", "Error while getting icc profile bytes.");
        }
    }

    private static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int reads = is.read();
        while (reads != -1) {
            baos.write(reads);
            reads = is.read();
        }
        return baos.toByteArray();
    }

    private static String getIntent(String str) {
        if (str == null) {
            return "Perceptual";
        }
        switch (str) {
            case "\u0000\u0000\u0000\u0001": {
                return "Media-Relative Colorimetric";
            }
            case "\u0000\u0000\u0000\u0002": {
                return "Saturation";
            }
            case "\u0000\u0000\u0000\u0003": {
                return "ICC-Absolute Colorimetric";
            }
        }
        return str;
    }

    private static String getVersion(byte[] header) {
        if (header[8] == 0 && header[9] == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(header[8] & 0xFF).append(".");
        builder.append((header[9] & 0xFF) >>> 4).append(".");
        builder.append(header[9] & 0xF);
        return builder.toString();
    }

    private static String getString(byte[] header, int begin, int end) {
        StringBuilder builder = new StringBuilder();
        boolean isEmpty = true;
        for (int i = begin; i < end; ++i) {
            if (header[i] != 0) {
                isEmpty = false;
            }
            builder.append((char)header[i]);
        }
        return isEmpty ? null : builder.toString();
    }

    private static Calendar getCreationDate(byte[] header) {
        int year = PBICCProfileFeaturesObject.getCreationPart(header, 24);
        int month = PBICCProfileFeaturesObject.getCreationPart(header, 26);
        int day = PBICCProfileFeaturesObject.getCreationPart(header, 28);
        int hour = PBICCProfileFeaturesObject.getCreationPart(header, 30);
        int min = PBICCProfileFeaturesObject.getCreationPart(header, 32);
        int sec = PBICCProfileFeaturesObject.getCreationPart(header, 34);
        if (year != 0 || month != 0 || day != 0 || hour != 0 || min != 0 || sec != 0) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(year, month - 1, day, hour, min, sec);
            cal.set(14, 0);
            return cal;
        }
        return null;
    }

    private static int getCreationPart(byte[] header, int off) {
        int part = header[off] & 0xFF;
        part <<= 8;
        return part += header[off + 1] & 0xFF;
    }

    private static String getStringTag(byte[] profileBytes, String tagName) {
        if (profileBytes.length < 132) {
            return null;
        }
        int tagsNumberRemained = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, 128, 132));
        int curOffset = 132;
        while (tagsNumberRemained > 0 && curOffset + 12 <= profileBytes.length) {
            String tag = new String(Arrays.copyOfRange(profileBytes, curOffset, curOffset + 4));
            if (tag.equals(tagName)) {
                int length;
                curOffset += 4;
                int offset = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, curOffset, curOffset + 4));
                if (profileBytes.length < offset + (length = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, curOffset += 4, curOffset + 4)))) {
                    return null;
                }
                String type = new String(Arrays.copyOfRange(profileBytes, offset, offset + 4));
                if ("mluc".equals(type)) {
                    int number = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, offset + 8, offset + 12));
                    int recOffset = offset + 12 + 4;
                    for (int i = 0; i < number; ++i) {
                        String local = PBICCProfileFeaturesObject.getString(profileBytes, recOffset, recOffset + 4);
                        if (!"enUS".equals(local)) continue;
                        length = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, recOffset + 4, recOffset + 4 + 4));
                        offset += PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, recOffset + 8, recOffset + 8 + 4));
                        try {
                            return new String(Arrays.copyOfRange(profileBytes, offset, offset + length), "UTF-16BE").trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException("Required UTF-16BE encoding not found", e);
                        }
                    }
                } else if ("desc".equals(type)) {
                    length = PBICCProfileFeaturesObject.byteArrayToInt(Arrays.copyOfRange(profileBytes, offset + 8, offset + 12));
                    offset += 12;
                } else {
                    offset += 4;
                    length -= 4;
                }
                return new String(Arrays.copyOfRange(profileBytes, offset, offset + length)).trim();
            }
            curOffset += 12;
        }
        return null;
    }

    private static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }
}

